/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.chunkbounds;

import at.feldim2425.moreoverlays.chunkbounds.ChunkBoundsRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChunkBoundsHandler {
    public static final int REGION_SIZEX = 32;
    public static final int REGION_SIZEZ = 32;
    public static final int REGION_SIZEY_CUBIC = 32;
    private static RenderMode mode = RenderMode.NONE;
    private final List<String> regionInfo = new ArrayList<String>();
    private final boolean isCubicChunksLoaded;
    private int playerPrevRegionPosX = Integer.MIN_VALUE;
    private int playerPrevRegionPosY = Integer.MIN_VALUE;
    private int playerPrevRegionPosZ = Integer.MIN_VALUE;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ChunkBoundsHandler(Loader.isModLoaded((String)"cubicchunks")));
    }

    public ChunkBoundsHandler(boolean modLoaded) {
        this.isCubicChunksLoaded = modLoaded;
    }

    public static RenderMode getMode() {
        return mode;
    }

    public static void setMode(RenderMode mode) {
        ChunkBoundsHandler.mode = mode;
    }

    public static void toggleMode() {
        RenderMode[] modes = RenderMode.values();
        mode = modes[(mode.ordinal() + 1) % modes.length];
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (mode != RenderMode.NONE) {
            ChunkBoundsRenderer.renderOverlays();
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (this.regionInfo.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P) {
            return;
        }
        int y = 0;
        for (String text : this.regionInfo) {
            mc.field_71466_p.func_175063_a(text, 10.0f, (float)(y += 10), 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (ChunkBoundsHandler.getMode() != RenderMode.REGIONS) {
            this.regionInfo.clear();
            this.playerPrevRegionPosX = 0;
            this.playerPrevRegionPosY = 0;
            this.playerPrevRegionPosZ = 0;
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean updateInfo = this.regionInfo.isEmpty();
        int newRegionX = player.field_70176_ah / 32;
        if (player.field_70176_ah < 0) {
            --newRegionX;
        }
        if (this.playerPrevRegionPosX != newRegionX) {
            this.playerPrevRegionPosX = newRegionX;
            updateInfo = true;
        }
        if (this.isCubicChunksLoaded) {
            int newRegionY = player.field_70162_ai / 32;
            if (player.field_70162_ai < 0) {
                --newRegionY;
            }
            if (this.playerPrevRegionPosY != newRegionY) {
                this.playerPrevRegionPosY = newRegionY;
                updateInfo = true;
            }
        }
        int newRegionZ = player.field_70164_aj / 32;
        if (player.field_70164_aj < 0) {
            --newRegionZ;
        }
        if (this.playerPrevRegionPosZ != newRegionZ) {
            this.playerPrevRegionPosZ = newRegionZ;
            updateInfo = true;
        }
        if (updateInfo) {
            this.regionInfo.clear();
            if (this.isCubicChunksLoaded) {
                this.regionInfo.add(String.format("region2d/%d.%d.2dr", this.playerPrevRegionPosX, this.playerPrevRegionPosZ));
                this.regionInfo.add(String.format("region3d/%d.%d.%d.3dr", this.playerPrevRegionPosX, this.playerPrevRegionPosY, this.playerPrevRegionPosZ));
            } else {
                this.regionInfo.add(String.format("region/r.%d.%d.mca", this.playerPrevRegionPosX, this.playerPrevRegionPosZ));
            }
        }
    }

    public static enum RenderMode {
        NONE,
        CORNERS,
        GRID,
        REGIONS;

    }
}

