/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TimeoutList<V>
implements ITickHandler,
Iterable<V> {
    private final TimeoutDelegate<V> delegate;
    private final EnumSet<TickEvent.Type> tickTypes;
    private List<TimeoutEntry<V>> tickEntries = new LinkedList<TimeoutEntry<V>>();

    public TimeoutList(@Nullable TimeoutDelegate<V> delegate, TickEvent.Type ... types) {
        this.delegate = delegate;
        this.tickTypes = EnumSet.noneOf(TickEvent.Type.class);
        for (TickEvent.Type type : types) {
            if (type == null) continue;
            this.tickTypes.add(type);
        }
    }

    public void add(V value) {
        this.add(0, value);
    }

    public void add(int timeout, V value) {
        if (value == null) {
            return;
        }
        this.tickEntries.add(new TimeoutEntry(timeout, value));
    }

    public boolean setTimeout(int timeout, @Nonnull V value) {
        for (TimeoutEntry<V> entry : this.tickEntries) {
            if (!((TimeoutEntry)entry).value.equals(value)) continue;
            ((TimeoutEntry)entry).timeout = timeout;
            return true;
        }
        return false;
    }

    public boolean setOrAddTimeout(int timeout, @Nonnull V value) {
        if (!this.contains(value)) {
            this.add(timeout, value);
            return true;
        }
        return this.setTimeout(timeout, value);
    }

    public boolean contains(V value) {
        if (value == null) {
            return false;
        }
        for (TimeoutEntry<V> entry : this.tickEntries) {
            if (!((TimeoutEntry)entry).value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public int getTimeout(V value) {
        for (TimeoutEntry<V> entry : this.tickEntries) {
            if (!((TimeoutEntry)entry).value.equals(value)) continue;
            return ((TimeoutEntry)entry).timeout;
        }
        return -1;
    }

    public void addAll(TimeoutList<V> entries) {
        if (entries == null) {
            return;
        }
        for (TimeoutEntry<V> entry : entries.tickEntries) {
            this.setOrAddTimeout(((TimeoutEntry)entry).timeout, ((TimeoutEntry)entry).value);
        }
    }

    public boolean isEmpty() {
        return this.tickEntries.isEmpty();
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        Iterator<TimeoutEntry<V>> iterator = this.tickEntries.iterator();
        while (iterator.hasNext()) {
            TimeoutEntry<V> entry = iterator.next();
            ((TimeoutEntry)entry).timeout--;
            if (((TimeoutEntry)entry).timeout > 0) continue;
            if (this.delegate != null) {
                this.delegate.onTimeout(((TimeoutEntry)entry).value);
            }
            iterator.remove();
        }
    }

    public void clear() {
        if (this.delegate != null) {
            this.tickEntries.forEach(entry -> this.delegate.onTimeout(((TimeoutEntry)entry).value));
        }
        this.tickEntries.clear();
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TimeoutList.this.tickEntries.size();
            }

            @Override
            public V next() {
                Object val = ((TimeoutEntry)TimeoutList.this.tickEntries.get(this.index)).value;
                ++this.index;
                return val;
            }
        };
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return this.tickTypes;
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "TimeoutList";
    }

    private static class TimeoutEntry<V> {
        private int timeout;
        @Nonnull
        private V value;

        private TimeoutEntry(int timeout, @Nonnull V value) {
            this.timeout = timeout;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeoutEntry that = (TimeoutEntry)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static interface TimeoutDelegate<V> {
        public void onTimeout(V var1);
    }
}

