/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.container.ContainerJournal;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemJournal
extends Item {
    public ItemJournal() {
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K && !playerIn.func_70093_af()) {
            AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.JOURNAL, playerIn, worldIn, 0, 0, 0);
        } else if (!worldIn.field_72995_K && playerIn.func_70093_af() && hand == EnumHand.MAIN_HAND) {
            AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.JOURNAL_STORAGE, playerIn, worldIn, 0, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    @Nullable
    public static ContainerJournal getContainer(InventoryPlayer playerInv, ItemStack stack, int journalIndex) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemJournal)) {
            return null;
        }
        return new ContainerJournal(playerInv, stack, journalIndex);
    }

    @Nullable
    public static IInventory getJournalStorage(ItemStack stack) {
        InventoryBasic i = new InventoryBasic("Journal", false, 27);
        ItemStack[] toFill = ItemJournal.getStoredConstellationStacks(stack);
        for (int i1 = 0; i1 < toFill.length; ++i1) {
            ItemStack item = toFill[i1];
            i.func_70299_a(i1, item);
        }
        return i;
    }

    public static ItemStack[] getStoredConstellationStacks(ItemStack stack) {
        List<IConstellation> out = ItemJournal.getStoredConstellations(stack);
        ItemStack[] items = new ItemStack[out.size()];
        for (int i = 0; i < out.size(); ++i) {
            IConstellation c = out.get(i);
            ItemStack paper = new ItemStack((Item)ItemsAS.constellationPaper);
            ItemConstellationPaper.setConstellation(paper, c);
            items[i] = paper;
        }
        return items;
    }

    public static List<IConstellation> getStoredConstellations(ItemStack stack) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        NBTTagList constellationPapers = cmp.func_150295_c("constellations", 8);
        LinkedList<IConstellation> out = new LinkedList<IConstellation>();
        for (int i = 0; i < constellationPapers.func_74745_c(); ++i) {
            IConstellation c = ConstellationRegistry.getConstellationByName(constellationPapers.func_150307_f(i));
            if (c == null) continue;
            out.add(c);
        }
        return out;
    }

    public static void setStoredConstellations(ItemStack parentJournal, LinkedList<IConstellation> saveConstellations) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(parentJournal);
        NBTTagList list = new NBTTagList();
        for (IConstellation c : saveConstellations) {
            list.func_74742_a((NBTBase)new NBTTagString(c.getUnlocalizedName()));
        }
        cmp.func_74782_a("constellations", (NBTBase)list);
    }
}

