/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.network.packet.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.BlockBreakAssist;
import hellfirepvp.astralsorcery.common.util.CropHelper;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColoredLens
extends Item
implements ItemDynamicColor {
    public ItemColoredLens() {
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (ColorType ct : ColorType.values()) {
                subItems.add((Object)new ItemStack((Item)this, 1, ct.getMeta()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int dmg;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColoredLens && (dmg = stack.func_77952_i()) >= 0 && dmg < ColorType.values().length) {
            tooltip.add(I18n.func_135052_a((String)("item.itemcoloredlens.effect." + ColorType.values()[dmg].name().toLowerCase() + ".name"), (Object[])new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileCrystalLens lens;
            int dmg;
            ItemStack inHand = playerIn.func_184586_b(EnumHand.MAIN_HAND);
            ColorType type = null;
            if (!inHand.func_190926_b() && inHand.func_77973_b() instanceof ItemColoredLens && (dmg = inHand.func_77952_i()) >= 0 && dmg < ColorType.values().length) {
                type = ColorType.values()[dmg];
            }
            if (type != null && (lens = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalLens.class, true)) != null) {
                ColorType oldType = lens.setLensColor(type);
                if (!playerIn.func_184812_l_()) {
                    inHand.func_190920_e(inHand.func_190916_E() - 1);
                    if (inHand.func_190916_E() <= 0) {
                        playerIn.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
                SoundHelper.playSoundAround((SoundEvent)Sounds.clipSwitch, worldIn, (Vec3i)pos, 0.8f, 1.5f);
                if (oldType != null) {
                    playerIn.field_71071_by.func_191975_a(worldIn, oldType.asStack());
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public int getColorForItemStack(ItemStack stack, int tintIndex) {
        int dmg = stack.func_77952_i();
        if (dmg < 0 || dmg >= ColorType.values().length) {
            return -1;
        }
        return ColorType.values()[dmg].colorRGB;
    }

    public static enum TargetType {
        ENTITY,
        BLOCK,
        NONE,
        ANY;

    }

    public static enum ColorType {
        FIRE(TargetType.ANY, 0xFF7F00, 0.07f),
        BREAK(TargetType.BLOCK, 0xFFDF00, 0.07f),
        GROW(TargetType.BLOCK, 57088, 0.07f),
        DAMAGE(TargetType.ENTITY, 0xDF0000, 0.07f),
        REGEN(TargetType.ENTITY, 0xFF7FBF, 0.07f),
        PUSH(TargetType.ENTITY, 57343, 0.07f),
        SPECTRAL(TargetType.NONE, 8323263, 0.25f);

        public final int colorRGB;
        public final Color wrappedColor;
        private final float flowReduction;
        private final TargetType type;

        private ColorType(TargetType type, int colorRGB, float flowReduction) {
            this.type = type;
            this.colorRGB = colorRGB;
            this.wrappedColor = new Color(colorRGB);
            this.flowReduction = flowReduction;
        }

        public TargetType getType() {
            return this.type;
        }

        public float getFlowReduction() {
            return this.flowReduction;
        }

        public String getUnlocalizedName() {
            return this.name().toLowerCase();
        }

        public ItemStack asStack() {
            return new ItemStack((Item)ItemsAS.coloredLens, 1, this.getMeta());
        }

        public int getMeta() {
            return this.ordinal();
        }

        public void onEntityInBeam(Vector3 beamOrigin, Vector3 beamTarget, Entity entity, float percStrength) {
            switch (this) {
                case FIRE: {
                    if (field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    if (entity instanceof EntityItem) {
                        ItemStack current = ((EntityItem)entity).func_92059_d();
                        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(current);
                        if (result.func_190926_b()) break;
                        Vector3 entityPos = Vector3.atEntityCenter(entity);
                        ItemUtils.dropItemNaturally(entity.func_130014_f_(), entityPos.getX(), entityPos.getY(), entityPos.getZ(), ItemUtils.copyStackWithSize(result, result.func_190916_E()));
                        if (current.func_190916_E() > 1) {
                            current.func_190918_g(1);
                            ((EntityItem)entity).func_92058_a(current);
                            break;
                        }
                        entity.func_70106_y();
                        break;
                    }
                    if (!(entity instanceof EntityLivingBase)) break;
                    entity.func_70015_d(1);
                    break;
                }
                case DAMAGE: {
                    if (!(entity instanceof EntityLivingBase)) {
                        return;
                    }
                    if (field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    if (entity instanceof EntityPlayer && entity.func_184102_h() != null && entity.func_184102_h().func_71219_W()) {
                        return;
                    }
                    DamageUtil.attackEntityFrom(entity, CommonProxy.dmgSourceStellar, 6.5f);
                    break;
                }
                case REGEN: {
                    if (!(entity instanceof EntityLivingBase)) {
                        return;
                    }
                    if (field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    ((EntityLivingBase)entity).func_70691_i(3.5f);
                    break;
                }
                case PUSH: {
                    if (entity instanceof EntityPlayer || field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    Vector3 dir = beamTarget.clone().subtract(beamOrigin).normalize().multiply(0.5f);
                    entity.field_70159_w = Math.min(1.0, entity.field_70179_y + dir.getX());
                    entity.field_70181_x = Math.min(1.0, entity.field_70181_x + dir.getY());
                    entity.field_70179_y = Math.min(1.0, entity.field_70179_y + dir.getZ());
                    break;
                }
            }
        }

        public void onBlockOccupyingBeam(World world, BlockPos at, IBlockState state, float percStrength) {
            switch (this) {
                case BREAK: {
                    float hardness = state.func_185887_b(world, at);
                    if (hardness < 0.0f) {
                        return;
                    }
                    BlockBreakAssist.addProgress(world, at, hardness *= 1.5f, percStrength * 4.0f);
                    PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.EffectType.BEAM_BREAK, at);
                    pkt.data = Block.func_176210_f((IBlockState)state);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(world, (Vec3i)at, 16.0));
                    break;
                }
                case GROW: {
                    if (world.field_73012_v.nextFloat() > percStrength) {
                        return;
                    }
                    CropHelper.GrowablePlant plant = CropHelper.wrapPlant(world, at);
                    if (plant == null) break;
                    plant.tryGrow(world, world.field_73012_v);
                    PktParticleEvent packet = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)packet, PacketChannel.pointFromPos(world, (Vec3i)at, 16.0));
                    break;
                }
                case FIRE: {
                    if (world.field_73012_v.nextFloat() > percStrength) {
                        return;
                    }
                    ItemStack blockStack = ItemUtils.createBlockStack(state);
                    if (blockStack.func_190926_b()) {
                        return;
                    }
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(blockStack);
                    if (result.func_190926_b()) {
                        return;
                    }
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_MELT_BLOCK, (Vec3i)at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)at, 16.0));
                    if (world.field_73012_v.nextInt(20) != 0) {
                        return;
                    }
                    IBlockState resState = ItemUtils.createBlockState(result);
                    if (resState == null) break;
                    world.func_175656_a(at, resState);
                    break;
                }
            }
        }
    }
}

