/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.BaseTweaker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.astralsorcery.GameStages")
public class GameStageTweaks
extends BaseTweaker {
    private static Map<String, Integer> stageLevelCap = new HashMap<String, Integer>();
    private static Map<String, Collection<String>> constellationStages = new HashMap<String, Collection<String>>();

    @ZenMethod
    public static void addLevelCap(String stageName, int levelCap) {
        stageLevelCap.put(stageName, levelCap);
    }

    @ZenMethod
    public static void addConstellationDiscoveryStage(String stageName, String unlocalizedConstellationName) {
        constellationStages.computeIfAbsent(unlocalizedConstellationName, str -> Lists.newArrayList()).add(stageName);
    }

    public static int getMaxCap(String gameStageName) {
        return stageLevelCap.getOrDefault(gameStageName, -1);
    }

    public static boolean canDiscover(Collection<String> gameStages, String constellationName) {
        Collection<String> stages = constellationStages.getOrDefault(constellationName, Lists.newArrayList());
        if (gameStages == null || stages.isEmpty()) {
            return true;
        }
        for (String gameStage : gameStages) {
            if (!stages.contains(gameStage)) continue;
            return true;
        }
        return false;
    }
}

