/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class ResearchIOThread
extends TimerTask {
    private static Timer ioThread;
    private static ResearchIOThread saveTask;
    private Map<UUID, PlayerProgress> playerSaveQueue = Maps.newHashMap();
    private Map<UUID, PlayerProgress> awaitingSaveQueue = Maps.newHashMap();
    private boolean inSave = false;
    private boolean skipTick = false;

    private ResearchIOThread() {
    }

    public static void startIOThread() {
        if (ioThread != null && saveTask != null) {
            return;
        }
        saveTask = new ResearchIOThread();
        ioThread = new Timer("ResearchIOThread", true);
        ioThread.scheduleAtFixedRate((TimerTask)saveTask, 30000L, 30000L);
    }

    @Override
    public void run() {
        if (this.skipTick) {
            return;
        }
        this.inSave = true;
        for (Map.Entry<UUID, PlayerProgress> entry : this.playerSaveQueue.entrySet()) {
            ResearchIOThread.saveNow(entry.getKey(), entry.getValue());
            if (!this.skipTick) continue;
            return;
        }
        this.playerSaveQueue.clear();
        this.inSave = false;
        this.playerSaveQueue.putAll(this.awaitingSaveQueue);
        this.awaitingSaveQueue.clear();
    }

    private void scheduleSave(UUID playerUUID, PlayerProgress copiedProgress) {
        if (this.inSave) {
            this.awaitingSaveQueue.put(playerUUID, copiedProgress);
        } else {
            this.playerSaveQueue.put(playerUUID, copiedProgress);
        }
    }

    private void cancelScheduledSave(UUID playerUUID) {
        this.awaitingSaveQueue.remove(playerUUID);
        this.playerSaveQueue.remove(playerUUID);
    }

    private void flushAndSaveAll() {
        this.skipTick = true;
        this.playerSaveQueue.putAll(this.awaitingSaveQueue);
        for (Map.Entry<UUID, PlayerProgress> entry : this.playerSaveQueue.entrySet()) {
            ResearchIOThread.saveNow(entry.getKey(), entry.getValue());
        }
        this.playerSaveQueue.clear();
        this.awaitingSaveQueue.clear();
        this.skipTick = false;
        this.inSave = false;
    }

    public static void saveProgress(UUID playerUUID, PlayerProgress copiedProgress) {
        if (saveTask != null) {
            saveTask.scheduleSave(playerUUID, copiedProgress);
        }
    }

    public static void cancelSave(UUID playerUUID) {
        if (saveTask != null) {
            saveTask.cancelScheduledSave(playerUUID);
        }
    }

    static void saveAllPending() {
        if (saveTask != null) {
            saveTask.flushAndSaveAll();
        }
    }

    static void saveNow(UUID playerUUID, PlayerProgress progress) {
        File playerFile = ResearchManager.getPlayerFile(playerUUID);
        try {
            Files.copy((File)playerFile, (File)ResearchManager.getPlayerBackupFile(playerUUID));
        }
        catch (IOException exc) {
            AstralSorcery.log.warn("Failed copying progress file contents to backup file!");
            exc.printStackTrace();
        }
        try {
            NBTTagCompound cmp = new NBTTagCompound();
            progress.store(cmp);
            CompressedStreamTools.func_74795_b((NBTTagCompound)cmp, (File)playerFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

