/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes.upgrade;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.block.BlockBlackMarble;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.crafting.IAltarUpgradeRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockAltar;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TraitUpgradeRecipe
extends ConstellationRecipe
implements IAltarUpgradeRecipe,
INighttimeRecipe,
ISpecialCraftingEffects {
    private static Vector3[] offsetPillars = new Vector3[]{new Vector3(4, 4, 4), new Vector3(-4, 4, 4), new Vector3(4, 4, -4), new Vector3(-4, 4, -4)};
    private static Object sprite;

    public TraitUpgradeRecipe() {
        super(TraitUpgradeRecipe.shapedRecipe("upgrade_tier4", new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_4.ordinal())).addPart(ItemHandle.getCrystalVariant(false, true), ShapedRecipeSlot.CENTER).addPart(ItemCraftingComponent.MetaType.GLASS_LENS.asStack(), ShapedRecipeSlot.UPPER_CENTER).addPart(BlockMarble.MarbleBlockType.RUNED.asStack(), ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT, ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT).unregisteredAccessibleShapedRecipe());
        this.setAttItem(BlockMarble.MarbleBlockType.RUNED.asStack(), AttunementRecipe.AttunementAltarSlot.values());
        this.setCstItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_RIGHT_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_LEFT_LEFT);
        this.setCstItem(BlockBlackMarble.BlackMarbleBlockType.RAW.asStack(), ConstellationRecipe.ConstellationAtlarSlot.UP_UP_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_UP_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_RIGHT);
    }

    @Override
    public TileAltar.AltarLevel getLevelUpgradingTo() {
        return TileAltar.AltarLevel.TRAIT_CRAFT;
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender() {
        return new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_4.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar tileAltar) {
        return ItemStack.field_190927_a;
    }

    @Override
    public AbstractAltarRecipe copyNewEffectInstance() {
        return new TraitUpgradeRecipe();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 r;
            int i;
            Vector3 altarVec = new Vector3(altar);
            Vector3 thisAltar = altarVec.clone().add(0.5, 0.5, 0.5);
            for (int i2 = 0; i2 < 4; ++i2) {
                Vector3 dir = offsetPillars[rand.nextInt(offsetPillars.length)].clone();
                dir.multiply(rand.nextFloat());
                dir.setY(dir.getY() * (double)rand.nextFloat());
                dir.add(thisAltar.clone());
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(dir.getX(), dir.getY(), dir.getZ());
                particle.setColor(MiscUtils.calcRandomConstellationColor(rand.nextFloat())).scale(0.4f + 0.2f * rand.nextFloat()).gravity(0.004);
                particle = EffectHelper.genericFlareParticle(dir.getX(), dir.getY(), dir.getZ());
                particle.setColor(Color.WHITE).scale(0.1f + 0.2f * rand.nextFloat()).gravity(0.004);
            }
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((float)(altar.func_174877_v().func_177958_n() - 3) + rand.nextFloat() * 7.0f, (double)altar.func_174877_v().func_177956_o() + 0.02, (float)(altar.func_174877_v().func_177952_p() - 3) + rand.nextFloat() * 7.0f);
            p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.15f);
            p.setColor(Color.WHITE);
            for (i = 0; i < 1; ++i) {
                r = Vector3.random().setY(0).normalize().multiply(1.3 + (double)rand.nextFloat() * 0.5).add(thisAltar.clone().addY(2.2));
                p = EffectHelper.genericFlareParticle(r.getX(), r.getY(), r.getZ());
                p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.1f);
                p.setColor(Color.WHITE);
            }
            for (i = 0; i < 2; ++i) {
                r = Vector3.random().setY(0).normalize().multiply(2.0 + (double)rand.nextFloat() * 0.5).add(thisAltar.clone().addY(1.3));
                p = EffectHelper.genericFlareParticle(r.getX(), r.getY(), r.getZ());
                p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.1f);
                p.setColor(Color.WHITE);
            }
            for (i = 0; i < 10; ++i) {
                Vector3 dir = offsetPillars[rand.nextInt(offsetPillars.length)].clone();
                dir.setY((double)rand.nextFloat() * dir.getY());
                dir.add(-0.3 + 1.6 * (double)rand.nextFloat(), 0.0, -0.3 + 1.6 * (double)rand.nextFloat());
                Vector3 r2 = altarVec.clone().add(dir);
                p = EffectHelper.genericFlareParticle(r2.getX(), r2.getY(), r2.getZ());
                p.gravity(0.01 + 0.02 * (double)rand.nextFloat()).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.5f + 0.3f);
                p.setColor(Color.WHITE);
            }
            if (rand.nextInt(10) == 0) {
                Vector3 from = new Vector3((double)((float)(altar.func_174877_v().func_177958_n() - 3) + rand.nextFloat() * 7.0f), (double)altar.func_174877_v().func_177956_o() + 0.02, (double)((float)(altar.func_174877_v().func_177952_p() - 3) + rand.nextFloat() * 7.0f));
                MiscUtils.applyRandomOffset(from, rand, 0.4f);
                EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(4 + rand.nextInt(2)), from, 1.0);
                lightbeam.setMaxAge(64);
                lightbeam.setColorOverlay(new Color(5466623));
            }
            if (sprite == null || ((TextureSpritePlane)sprite).isRemoved()) {
                TextureSpritePlane pl = EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteFlare2, Vector3.RotAxis.Y_AXIS.clone());
                pl.setPosition(new Vector3(altar).add(0.5, 0.04, 0.5));
                pl.setScale(9.0f).setAlphaMultiplier(0.65f).setNoRotation(0.0f);
                pl.setColorOverlay(new Color(5269228));
                pl.setRefreshFunc(() -> !altar.func_145837_r() && altar.func_145831_w().func_175625_s(altar.func_174877_v()) != null && altar.func_145831_w().func_175625_s(altar.func_174877_v()).equals(altar) && altar.getActiveCraftingTask() != null && altar.getActiveCraftingTask().getState() == ActiveCraftingTask.CraftingState.ACTIVE && !altar.getActiveCraftingTask().getRecipeToCraft().getOutputForMatching().func_190926_b() && altar.getActiveCraftingTask().getRecipeToCraft().getOutputForMatching().func_77973_b() instanceof ItemBlockAltar && altar.getActiveCraftingTask().getRecipeToCraft().getOutputForMatching().func_77952_i() == 3);
                sprite = pl;
            }
        }
    }
}

