/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.controller.ControllerNoisePlane;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileBore;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VortexBoreRecipe
extends TraitRecipe
implements ISpecialCraftingEffects {
    public VortexBoreRecipe() {
        super(ShapedRecipe.Builder.newShapedRecipe("internal/altar/bore_head_vortex", TileBore.BoreType.VORTEX.asStack()).addPart(ItemHandle.getCrystalVariant(false, false), ShapedRecipeSlot.UPPER_CENTER).addPart(OreDictAlias.ITEM_STARMETAL_DUST, ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT).addPart(BlockMarble.MarbleBlockType.RUNED.asStack(), ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT).unregisteredAccessibleShapedRecipe());
        this.setInnerTraitItem(OreDictAlias.ITEM_STARMETAL_DUST, TraitRecipe.TraitRecipeSlot.LOWER_CENTER);
        this.setInnerTraitItem(BlockMarble.MarbleBlockType.RUNED.asStack(), TraitRecipe.TraitRecipeSlot.LEFT_CENTER, TraitRecipe.TraitRecipeSlot.RIGHT_CENTER, TraitRecipe.TraitRecipeSlot.UPPER_CENTER);
        this.setCstItem(BlockMarble.MarbleBlockType.RUNED.asStack(), ConstellationRecipe.ConstellationAtlarSlot.values());
        this.setAttItem(BlockMarble.MarbleBlockType.RUNED.asStack(), AttunementRecipe.AttunementAltarSlot.LOWER_LEFT, AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT);
        this.setAttItem(OreDictAlias.ITEM_GOLD_INGOT, AttunementRecipe.AttunementAltarSlot.UPPER_LEFT, AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT);
        this.addOuterTraitItem(ItemUsableDust.DustType.NOCTURNAL.asStack());
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack());
        this.addOuterTraitItem(ItemUsableDust.DustType.NOCTURNAL.asStack());
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack());
        this.addOuterTraitItem(ItemUsableDust.DustType.NOCTURNAL.asStack());
        this.setPassiveStarlightRequirement(4400);
        this.setRequiredConstellation(Constellations.vicio);
    }

    @Override
    public AbstractAltarRecipe copyNewEffectInstance() {
        return new VortexBoreRecipe();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        ActiveCraftingTask current;
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE && (current = this.getCurrentTask(altar)) != null) {
            EntityFXFacingParticle p;
            int i;
            Vector3 pos = new Vector3(altar).add(0.5, 0.5, 0.5);
            Vector3 target = new Vector3(altar).add(0.5, 4.5, 0.5);
            for (int i2 = 0; i2 < 4; ++i2) {
                Vector3 p2 = new Vector3(altar).add(-3.0f + rand.nextFloat() * 7.0f, 0.02, -3.0f + rand.nextFloat() * 7.0f);
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(p2);
                particle.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.15f);
                particle.setColor(Color.WHITE);
                Vector3 mot = target.clone().subtract(p2).normalize().multiply(0.09);
                particle.motion(mot.getX(), mot.getY(), mot.getZ());
            }
            ControllerNoisePlane ctrl = current.getEffectContained(0, index -> new ControllerNoisePlane(1.2f));
            for (i = 0; i < 2; ++i) {
                p = ctrl.setupParticle();
                p.updatePosition(pos.getX(), pos.getY() + 4.0, pos.getZ()).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).motion((double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1)).scale(0.15f + rand.nextFloat() * 0.05f).setMaxAge(30 + rand.nextInt(15));
            }
            ctrl = current.getEffectContained(1, index -> new ControllerNoisePlane(1.8f));
            for (i = 0; i < 2; ++i) {
                p = ctrl.setupParticle();
                p.updatePosition(pos.getX(), pos.getY() + 4.0, pos.getZ()).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).motion((double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.005 * (double)(rand.nextBoolean() ? 1 : -1)).scale(0.15f + rand.nextFloat() * 0.05f).setMaxAge(30 + rand.nextInt(15));
            }
        }
    }
}

