/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.root;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeModifierPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePointConstellation;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class RootPerk
extends AttributeModifierPerk {
    protected float expMultiplier = 1.0f;
    private final IMajorConstellation constellation;

    public RootPerk(String name, IMajorConstellation constellation, int x, int y) {
        super(name, x, y);
        this.setCategory(AbstractPerk.CATEGORY_ROOT);
        this.setRequireDiscoveredConstellation(constellation);
        this.constellation = constellation;
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, "root_" + name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                RootPerk.this.expMultiplier = cfg.getFloat("Exp_Multiplier", this.getConfigurationSection(), RootPerk.this.expMultiplier, 0.0f, 1024.0f, "Sets the exp multiplier exp gained from this root-perk are multiplied by. (So higher multiplier -> more exp)");
                RootPerk.this.loadAdditionalConfigurations(cfg);
            }
        });
    }

    protected PerkTreePoint<? extends RootPerk> initPerkTreePoint() {
        return new PerkTreePointConstellation<RootPerk>(this, this.getOffset(), this.constellation, 50);
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.expMultiplier = (float)((double)this.expMultiplier * multiplier);
    }

    protected void loadAdditionalConfigurations(Configuration cfg) {
    }

    public IConstellation getConstellation() {
        return this.constellation;
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, EntityPlayer player) {
        AbstractPerk core;
        if (progress.hasFreeAllocationPoint(player) && this.canSee(player, progress) && (core = PerkTree.PERK_TREE.getAstralSorceryPerk("core")) != null && progress.hasPerkEffect(core)) {
            return true;
        }
        return super.mayUnlockPerk(progress, player);
    }
}

