/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.flare;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PatreonFlareManager
implements ITickHandler {
    public static PatreonFlareManager INSTANCE = new PatreonFlareManager();

    private PatreonFlareManager() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        DataPatreonFlares dataFlares = (DataPatreonFlares)SyncDataHolder.getDataServer("PatreonFlares");
        ArrayList<UUID> ownerDiff = new ArrayList<UUID>(dataFlares.getOwners(Side.SERVER));
        for (Map.Entry<UUID, List<PatreonEffectHelper.PatreonEffect>> effect : PatreonEffectHelper.getPatreonEffects(server.func_184103_al().func_181057_v()).entrySet()) {
            EntityPlayerMP owner = server.func_184103_al().func_177451_a(effect.getKey());
            Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> knownEntities = dataFlares.getEntities(Side.SERVER, owner.func_110124_au());
            ownerDiff.remove(owner.func_110124_au());
            for (PatreonEffectHelper.PatreonEffect pe : effect.getValue()) {
                if (!pe.hasPartialEntity()) continue;
                PatreonPartialEntity entity = knownEntities.get(pe);
                if (entity == null) {
                    entity = dataFlares.createEntity((EntityPlayer)owner, pe);
                }
                World plWorld = owner.func_130014_f_();
                if (entity.getLastTickedDim() != null && plWorld.field_73011_w.getDimension() != entity.getLastTickedDim().intValue()) {
                    entity.setPositionNear((EntityPlayer)owner);
                }
                if (!entity.update(plWorld)) continue;
                dataFlares.updateEntity(entity);
            }
        }
        for (UUID removedOwner : ownerDiff) {
            Map<PatreonEffectHelper.PatreonEffect, PatreonPartialEntity> knownEntities = dataFlares.getEntities(Side.SERVER, removedOwner);
            for (PatreonPartialEntity entity : knownEntities.values()) {
                dataFlares.destroyEntity(entity);
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Patreon Flare Manager (Server)";
    }
}

