/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

import java.awt.Point;
import java.awt.geom.Point2D;
import javax.annotation.Nullable;

public abstract class SizeHandler {
    private static final int W_H_NODE = 18;
    public final double heightToBorder;
    public final double widthToBorder;
    private int widthHeightNodes = 18;
    private int spaceBetweenNodes = 18;
    private double midX;
    private double midY;
    private double totalWidth;
    private double totalHeight;
    private double scalingFactor = 1.0;
    private double maxScale = 10.0;
    private double minScale = 1.0;
    private double scaleSpeed = 0.2;

    public SizeHandler(int height, int width) {
        this.heightToBorder = height / 2;
        this.widthToBorder = width / 2;
    }

    public void setMaxScale(double maxScale) {
        this.maxScale = maxScale;
    }

    public void setScaleSpeed(double scaleSpeed) {
        this.scaleSpeed = scaleSpeed;
    }

    public void setMinScale(double minScale) {
        this.minScale = minScale;
    }

    public void setWidthHeightNodes(int widthHeightNodes) {
        this.widthHeightNodes = widthHeightNodes;
    }

    public void setSpaceBetweenNodes(int spaceBetweenNodes) {
        this.spaceBetweenNodes = spaceBetweenNodes;
    }

    public void updateSize() {
        this.resetZoom();
        int leftMost = 0;
        int rightMost = 0;
        int upperMost = 0;
        int lowerMost = 0;
        int[] requiredRect = this.buildRequiredRectangle();
        if (requiredRect != null) {
            leftMost = requiredRect[0];
            rightMost = requiredRect[1];
            upperMost = requiredRect[2];
            lowerMost = requiredRect[3];
        }
        leftMost = Math.abs(leftMost);
        rightMost = Math.abs(rightMost);
        upperMost = Math.abs(upperMost);
        lowerMost = Math.abs(lowerMost);
        int leftAdded = leftMost * this.widthHeightNodes + leftMost * this.spaceBetweenNodes;
        int rightAdded = rightMost * this.widthHeightNodes + rightMost * this.spaceBetweenNodes;
        int upperAdded = upperMost * this.widthHeightNodes + upperMost * this.spaceBetweenNodes;
        int lowerAdded = lowerMost * this.widthHeightNodes + lowerMost * this.spaceBetweenNodes;
        this.midX = this.widthToBorder + (double)leftAdded;
        this.totalWidth = this.widthToBorder + (double)rightAdded + this.midX;
        this.midY = this.heightToBorder + (double)upperAdded;
        this.totalHeight = this.heightToBorder + (double)lowerAdded + this.midY;
    }

    @Nullable
    public abstract int[] buildRequiredRectangle();

    public double getMidX() {
        return this.midX * this.scalingFactor;
    }

    public double getMidY() {
        return this.midY * this.scalingFactor;
    }

    public double getTotalWidth() {
        return this.totalWidth * this.scalingFactor;
    }

    public double getTotalHeight() {
        return this.totalHeight * this.scalingFactor;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public double getZoomedWHNode() {
        return (double)this.widthHeightNodes * this.scalingFactor;
    }

    public double getZoomedSpaceBetweenNodes() {
        return (double)this.spaceBetweenNodes * this.scalingFactor;
    }

    public double scaleAccordingly(double toScale) {
        return toScale * this.scalingFactor;
    }

    public void handleZoomIn() {
        if (this.scalingFactor >= this.maxScale) {
            return;
        }
        this.scalingFactor = Math.min(this.maxScale, this.scalingFactor + this.scaleSpeed);
    }

    public void handleZoomOut() {
        if (this.scalingFactor <= this.minScale) {
            return;
        }
        this.scalingFactor = Math.max(this.minScale, this.scalingFactor - this.scaleSpeed);
    }

    public void forceScaleTo(double scale) {
        this.scalingFactor = scale;
    }

    public void resetZoom() {
        this.scalingFactor = 1.0;
    }

    public double clampX(double centerX) {
        if (centerX + this.widthToBorder > this.getTotalWidth()) {
            centerX = this.getTotalWidth() - this.widthToBorder;
        }
        if (centerX - this.widthToBorder < 0.0) {
            centerX = this.widthToBorder;
        }
        return centerX;
    }

    public double clampY(double centerY) {
        if (centerY + this.heightToBorder > this.getTotalHeight()) {
            centerY = this.getTotalHeight() - this.heightToBorder;
        }
        if (centerY - this.heightToBorder < 0.0) {
            centerY = this.heightToBorder;
        }
        return centerY;
    }

    public double evRelativePosX(int relativeX) {
        return this.getMidX() + (double)relativeX * (this.getZoomedWHNode() + this.getZoomedSpaceBetweenNodes());
    }

    public double evRelativePosY(int relativeY) {
        return this.getMidY() + (double)relativeY * (this.getZoomedWHNode() + this.getZoomedSpaceBetweenNodes());
    }

    public Point2D.Double evRelativePos(Point offset) {
        return new Point2D.Double(this.evRelativePosX(offset.x), this.evRelativePosY(offset.y));
    }
}

