/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.controller;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class ControllerNoisePlane
implements EntityComplexFX.RenderOffsetController {
    private static final Random T_RAND = new Random();
    private static final int SAMPLE_TIME_MIN = 35;
    private static final int SAMPLE_TIME_MAX = 55;
    private long lastSample;
    private long targetSample;
    private final float ringSize;
    private Vector3 prevRotationDeg;
    private Vector3 rotationDeg;

    public ControllerNoisePlane(float ringSizeDiameter) {
        this.ringSize = ringSizeDiameter;
        this.buildRotations();
        this.lastSample = ClientScheduler.getClientTick() - (long)this.randomSampleTime();
        this.targetSample = this.lastSample + (long)this.randomSampleTime();
    }

    public EntityFXFacingParticle setupParticle() {
        FXPlanarEffect p = new FXPlanarEffect(0.0, 0.0, 0.0, T_RAND.nextFloat() * 360.0f, this.ringSize * 0.9f + T_RAND.nextFloat() * this.ringSize * 0.2f);
        p.enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).setAlphaMultiplier(0.75f).setColor(Color.WHITE);
        p.setRenderOffsetController(this).gravity(0.004);
        EffectHandler.getInstance().registerFX(p);
        return p;
    }

    private Vector3 getCurrentRotationDegree(float partial) {
        this.checkRotations();
        long current = ClientScheduler.getClientTick();
        double perc = 1.0 - (double)((float)(this.targetSample - current) - partial) / (double)(this.targetSample - this.lastSample);
        return this.interpolateRotation(perc, this.prevRotationDeg, this.rotationDeg);
    }

    private void checkRotations() {
        if (ClientScheduler.getClientTick() >= this.targetSample) {
            this.buildRotations();
        }
    }

    private void buildRotations() {
        this.lastSample = ClientScheduler.getClientTick();
        this.prevRotationDeg = this.rotationDeg != null ? this.rotationDeg : Vector3.positiveYRandom();
        this.rotationDeg = Vector3.positiveYRandom();
        this.targetSample = this.lastSample + (long)this.randomSampleTime();
    }

    private int randomSampleTime() {
        return T_RAND.nextInt(55);
    }

    private Vector3 interpolateRotation(double partial, Vector3 vZero, Vector3 vOne) {
        double v = 20.0 * MathHelper.func_151237_a((double)partial, (double)0.0, (double)1.0) - 10.0;
        v = MathHelper.func_151237_a((double)(Math.atan(v) / 2.9423 + 0.5), (double)0.0, (double)1.0);
        return this.getInterpolatedVectorRotation((float)v, vZero, vOne);
    }

    private Vector3 getInterpolatedVectorRotation(float percent, Vector3 vZero, Vector3 vOne) {
        return new Vector3(RenderingUtils.interpolate(vZero.getX(), vOne.getX(), percent), RenderingUtils.interpolate(vZero.getY(), vOne.getY(), percent), RenderingUtils.interpolate(vZero.getZ(), vOne.getZ(), percent));
    }

    @Override
    public Vector3 changeRenderPosition(EntityComplexFX fx, Vector3 currentRenderPos, Vector3 currentMotion, float pTicks) {
        if (!(fx instanceof FXPlanarEffect)) {
            return currentRenderPos;
        }
        Vector3 angle = this.getCurrentRotationDegree(pTicks);
        Vector3 v = angle.clone().perpendicular().normalize().multiply(((FXPlanarEffect)fx).initialDistance);
        v.rotate(Math.toRadians(((FXPlanarEffect)fx).degreeRotation), angle);
        return currentRenderPos.add(v);
    }

    private static class FXPlanarEffect
    extends EntityFXFacingParticle {
        private final float degreeRotation;
        private final float initialDistance;

        FXPlanarEffect(double x, double y, double z, float degreeRotation, float initialDistance) {
            super(x, y, z);
            this.degreeRotation = degreeRotation;
            this.initialDistance = initialDistance;
        }
    }
}

