/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.data;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.data.CachedPersistentData;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragment;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragmentManager;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class KnowledgeFragmentData
extends CachedPersistentData {
    private List<KnowledgeFragment> flattenedFragments = Lists.newArrayList();
    private List<KnowledgeFragment> cacheCreativeFragments = Lists.newArrayList();
    private List<KnowledgeFragment> mergedCache = null;

    KnowledgeFragmentData() {
        super(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS);
    }

    @Override
    protected boolean mergeFrom(CachedPersistentData that) {
        boolean changed = false;
        if (that instanceof KnowledgeFragmentData) {
            for (KnowledgeFragment other : ((KnowledgeFragmentData)that).flattenedFragments) {
                changed |= this.addFragmentCache(other);
            }
        }
        return changed;
    }

    @Override
    public void clearCreativeCaches() {
        super.clearCreativeCaches();
        this.cacheCreativeFragments.clear();
        this.mergedCache = null;
    }

    public List<KnowledgeFragment> getAllFragments() {
        if (this.mergedCache == null) {
            this.mergedCache = new ArrayList<KnowledgeFragment>(this.flattenedFragments.size() + this.cacheCreativeFragments.size());
            this.mergedCache.addAll(this.flattenedFragments);
            this.mergedCache.addAll(this.cacheCreativeFragments);
        }
        return this.mergedCache;
    }

    public List<KnowledgeFragment> getDiscoverableFragments() {
        PlayerProgress prog = ResearchManager.getProgress((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        List<KnowledgeFragment> frag = KnowledgeFragmentManager.getInstance().getAllFragments();
        frag.removeAll(this.flattenedFragments);
        frag.removeIf(f -> !f.canDiscover(prog));
        return frag;
    }

    public Collection<KnowledgeFragment> getFragmentsFor(GuiScreenJournal journal) {
        PlayerProgress prog = ResearchManager.getProgress((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        return this.getAllFragments().stream().filter(f -> f.isVisible(journal) && f.canSee(prog) && f.isFullyPresent()).collect(Collectors.toList());
    }

    public boolean addFragment(KnowledgeFragment fragment) {
        return this.addFragmentCache(fragment) && this.save();
    }

    private boolean addFragmentCache(KnowledgeFragment frag) {
        List<KnowledgeFragment> target;
        List<KnowledgeFragment> list = target = this.creative ? this.cacheCreativeFragments : this.flattenedFragments;
        if (this.getAllFragments().contains(frag)) {
            return false;
        }
        this.mergedCache = null;
        return target.add(frag);
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        this.flattenedFragments.clear();
        KnowledgeFragmentManager mgr = KnowledgeFragmentManager.getInstance();
        for (NBTBase tag : cmp.func_150295_c("fragments", 8)) {
            String str;
            KnowledgeFragment frag;
            if (!(tag instanceof NBTTagString) || (frag = mgr.getFragment(new ResourceLocation(str = ((NBTTagString)tag).func_150285_a_()))) == null) continue;
            this.addFragmentCache(frag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        List<KnowledgeFragment> flattened = this.flattenedFragments;
        NBTTagList listFragments = new NBTTagList();
        for (KnowledgeFragment frag : flattened) {
            listFragments.func_74742_a((NBTBase)new NBTTagString(frag.getRegistryName().toString()));
        }
        cmp.func_74782_a("fragments", (NBTBase)listFragments);
    }
}

