/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MiscUtils {
    public static <K, V, N> Map<K, N> remap(Map<K, V> map, Function<V, N> remapFct) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> remapFct.apply(e.getValue())));
    }

    public static List<String> splitStringBy(String str, String spl) {
        return Lists.newArrayList((Object[])str.split(spl));
    }

    public static <T> List<T> flatten(Collection<List<T>> collection) {
        return collection.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nullable
    public static <T> T iterativeSearch(Collection<T> collection, Predicate<T> matchingFct) {
        for (T element : collection) {
            if (!matchingFct.test(element)) continue;
            return element;
        }
        return null;
    }

    public static long clamp(long num, long min, long max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }
}

