/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import cofh.redstoneflux.api.IEnergyStorage;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchSize;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyInputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyOutputHatch;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyStorage", modid="redstoneflux")
public abstract class TileEnergyHatch
extends TileColorableMachineComponent
implements ITickable,
net.minecraftforge.energy.IEnergyStorage,
IEnergyHandler,
MachineComponentTile,
IEnergyStorage {
    protected long energy = 0L;
    protected EnergyHatchSize size;

    public TileEnergyHatch() {
    }

    public TileEnergyHatch(EnergyHatchSize size) {
        this.size = size;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int insertable = this.energy + (long)maxReceive > this.size.maxEnergy ? this.convertDownEnergy(this.size.maxEnergy - this.energy) : maxReceive;
        insertable = Math.min(insertable, this.size.transferLimit);
        if (!simulate) {
            this.energy = MiscUtils.clamp(this.energy + (long)insertable, 0L, this.size.maxEnergy);
            this.markForUpdate();
        }
        return insertable;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extractable = this.energy - (long)maxExtract < 0L ? this.convertDownEnergy(this.energy) : maxExtract;
        extractable = Math.min(extractable, this.size.transferLimit);
        if (!simulate) {
            this.energy = MiscUtils.clamp(this.energy - (long)extractable, 0L, this.size.maxEnergy);
            this.markForUpdate();
        }
        return extractable;
    }

    public int getEnergyStored() {
        return this.convertDownEnergy(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.convertDownEnergy(this.size.maxEnergy);
    }

    public boolean canExtract() {
        return this instanceof TileEnergyOutputHatch;
    }

    public boolean canReceive() {
        return this instanceof TileEnergyInputHatch;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        NBTBase energyTag = compound.func_74781_a("energy");
        if (energyTag instanceof NBTPrimitive) {
            this.energy = ((NBTPrimitive)energyTag).func_150291_c();
        }
        this.size = EnergyHatchSize.values()[compound.func_74762_e("hatchSize")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74772_a("energy", this.energy);
        compound.func_74768_a("hatchSize", this.size.ordinal());
    }

    protected int convertDownEnergy(long energy) {
        return energy >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }

    @Override
    public int getCurrentEnergy() {
        return this.convertDownEnergy(this.energy);
    }

    @Override
    public void setCurrentEnergy(int energy) {
        this.energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergy());
        this.markForUpdate();
    }

    @Override
    public int getMaxEnergy() {
        return this.convertDownEnergy(this.size.maxEnergy);
    }
}

