/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.selection;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.network.PktSyncSelection;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerStructureSelectionHelper {
    public static StructureSelection clientSelection = null;
    private static Map<UUID, StructureSelection> activeSelectionMap = new HashMap<UUID, StructureSelection>();

    public static void toggleInSelection(EntityPlayer player, BlockPos pos) {
        PlayerStructureSelectionHelper.activeSelectionMap.computeIfAbsent(player.func_110124_au(), uuid -> new StructureSelection()).togglePosition(pos);
    }

    public static void purgeSelection(EntityPlayer player) {
        if (player == null) {
            return;
        }
        activeSelectionMap.remove(player.func_110124_au());
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        INetHandlerPlayServer handlerServer = (INetHandlerPlayServer)event.getHandler();
        if (handlerServer instanceof NetHandlerPlayServer) {
            PlayerStructureSelectionHelper.purgeSelection((EntityPlayer)((NetHandlerPlayServer)handlerServer).field_147369_b);
        }
    }

    public static void sendSelection(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ModularMachinery.NET_CHANNEL.sendTo((IMessage)new PktSyncSelection(activeSelectionMap.computeIfAbsent(player.func_110124_au(), uuid -> new StructureSelection()).getSelectedPositions()), (EntityPlayerMP)player);
        }
    }

    public static void finalizeSelection(EnumFacing controllerFacing, World world, BlockPos pos, EntityPlayer player) {
        block8: {
            StructureSelection sel = activeSelectionMap.get(player.func_110124_au());
            if (sel == null || sel.selectedPositions.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.structurebuild.empty", new Object[0]));
                return;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.structurebuild.confirmrotation", new Object[]{controllerFacing.func_176610_l()}));
            BlockArray out = sel.compressAsArray(world, pos);
            if (controllerFacing != EnumFacing.NORTH) {
                int rotation = 0;
                EnumFacing face = controllerFacing;
                while (face != EnumFacing.NORTH) {
                    face = face.func_176735_f();
                    rotation += 90;
                    out = out.rotateYCCW();
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.structurebuild.confirmrotation.rotating", new Object[]{String.valueOf(rotation)}));
            }
            if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                String serializedArray = out.serializeAsMachineJson();
                MinecraftServer ms = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (ms.func_71262_S()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.structurebuild.warndedicated", new Object[0]));
                }
                String timestampAppend = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                String fileName = "machine-" + player.func_70005_c_() + "-" + timestampAppend;
                File directory = CommonProxy.dataHolder.getMachineryDirectory();
                File machineOut = new File(directory, fileName + ".json");
                int increment = 0;
                while (machineOut.exists()) {
                    machineOut = new File(directory, fileName + " (" + increment + ").json");
                    ++increment;
                }
                try {
                    Files.write((CharSequence)serializedArray, (File)machineOut, (Charset)Charset.forName("UTF-8"));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.structurebuild.save", new Object[]{machineOut.getName()}));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.structurebuild.fail", new Object[0]));
                    if (!machineOut.exists()) break block8;
                    machineOut.delete();
                }
            }
        }
    }

    public static class StructureSelection {
        private List<BlockPos> selectedPositions = new LinkedList<BlockPos>();

        private StructureSelection() {
        }

        public StructureSelection(List<BlockPos> selectedPositions) {
            this.selectedPositions = selectedPositions;
        }

        public List<BlockPos> getSelectedPositions() {
            return new ArrayList<BlockPos>(this.selectedPositions);
        }

        private void togglePosition(BlockPos pos) {
            if (this.selectedPositions.contains(pos)) {
                this.selectedPositions.remove(pos);
            } else {
                this.selectedPositions.add(pos);
            }
        }

        private BlockArray compressAsArray(World world, BlockPos center) {
            BlockArray out = new BlockArray();
            for (BlockPos pos : this.selectedPositions) {
                IBlockState state = world.func_180495_p(pos);
                BlockArray.IBlockStateDescriptor descr = new BlockArray.IBlockStateDescriptor(state);
                BlockArray.BlockInformation bi = new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{descr}));
                TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    NBTTagCompound cmp = new NBTTagCompound();
                    te.func_189515_b(cmp);
                    cmp.func_82580_o("x");
                    cmp.func_82580_o("y");
                    cmp.func_82580_o("z");
                    bi.setMatchingTag(cmp);
                }
                out.addBlock(pos.func_177973_b((Vec3i)center), bi);
            }
            return out;
        }
    }
}

