/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.preview;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.ClientMouseJEIGuiEventHandler;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.client.util.DynamicMachineRenderContext;
import hellfirepvp.modularmachinery.client.util.RenderingUtils;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockCompatHelper;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class StructurePreviewWrapper
implements IRecipeWrapper {
    private static final Field layouts;
    private static final Field recipeLayoutWrapper;
    private static final ResourceLocation ic2TileBlock;
    public static final ResourceLocation TEXTURE_BACKGROUND;
    private final IDrawable drawableArrowDown;
    private final IDrawable drawableArrowUp;
    private final IDrawable drawable3DDisabled;
    private final IDrawable drawable3DHover;
    private final IDrawable drawable3DActive;
    private final IDrawable drawable2DDisabled;
    private final IDrawable drawable2DHover;
    private final IDrawable drawable2DActive;
    private final IDrawable drawablePopOutDisabled;
    private final IDrawable drawablePopOutHover;
    private final IDrawable drawablePopOutActive;
    private final IDrawable drawableContentsDisabled;
    private final IDrawable drawableContentsHover;
    private final IDrawable drawableContentsActive;
    private final IDrawable drawableUpgradesHover;
    private final DynamicMachine machine;
    private DynamicMachineRenderContext dynamnicContext;
    public static long lastRenderMs;

    public StructurePreviewWrapper(DynamicMachine machine) {
        this.machine = machine;
        IGuiHelper h = ModIntegrationJEI.jeiHelpers.getGuiHelper();
        this.drawableArrowDown = h.createDrawable(TEXTURE_BACKGROUND, 176, 0, 16, 16);
        this.drawableArrowUp = h.createDrawable(TEXTURE_BACKGROUND, 192, 0, 16, 16);
        this.drawable3DDisabled = h.createDrawable(TEXTURE_BACKGROUND, 176, 16, 16, 16);
        this.drawable3DHover = h.createDrawable(TEXTURE_BACKGROUND, 192, 16, 16, 16);
        this.drawable3DActive = h.createDrawable(TEXTURE_BACKGROUND, 208, 16, 16, 16);
        this.drawable2DDisabled = h.createDrawable(TEXTURE_BACKGROUND, 176, 32, 16, 16);
        this.drawable2DHover = h.createDrawable(TEXTURE_BACKGROUND, 192, 32, 16, 16);
        this.drawable2DActive = h.createDrawable(TEXTURE_BACKGROUND, 208, 32, 16, 16);
        this.drawablePopOutDisabled = h.createDrawable(TEXTURE_BACKGROUND, 176, 48, 16, 16);
        this.drawablePopOutHover = h.createDrawable(TEXTURE_BACKGROUND, 192, 48, 16, 16);
        this.drawablePopOutActive = h.createDrawable(TEXTURE_BACKGROUND, 208, 48, 16, 16);
        this.drawableContentsDisabled = h.createDrawable(TEXTURE_BACKGROUND, 176, 64, 16, 16);
        this.drawableContentsHover = h.createDrawable(TEXTURE_BACKGROUND, 192, 64, 16, 16);
        this.drawableContentsActive = h.createDrawable(TEXTURE_BACKGROUND, 208, 64, 16, 16);
        this.drawableUpgradesHover = h.createDrawable(TEXTURE_BACKGROUND, 0, 145, 100, 14);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.dynamnicContext == null) {
            return false;
        }
        if (mouseButton == 0) {
            if (!this.dynamnicContext.doesRenderIn3D()) {
                if (mouseX >= 132 && mouseX <= 148 && mouseY >= 106 && mouseY <= 122) {
                    this.dynamnicContext.setTo3D();
                }
                if (this.dynamnicContext.hasSliceUp() && mouseX >= 150 && mouseX <= 166 && mouseY >= 102 && mouseY <= 118) {
                    this.dynamnicContext.sliceUp();
                }
                if (this.dynamnicContext.hasSliceDown() && mouseX >= 150 && mouseX <= 166 && mouseY >= 124 && mouseY <= 140) {
                    this.dynamnicContext.sliceDown();
                }
            } else if (mouseX >= 132 && mouseX <= 148 && mouseY >= 122 && mouseY <= 138) {
                this.dynamnicContext.setTo2D();
            }
            if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E) && mouseX >= 116 && mouseX <= 132 && mouseY >= 106 && mouseY < 122 && ClientProxy.renderHelper.startPreview(this.dynamnicContext)) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        }
        return false;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String reqBlueprint;
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        WorldClient clWorld = minecraft.field_71441_e;
        if (current == null || clWorld == null || !(current instanceof RecipesGui)) {
            return;
        }
        if (this.dynamnicContext == null) {
            this.dynamnicContext = DynamicMachineRenderContext.createContext(this.machine);
        }
        if (System.currentTimeMillis() - lastRenderMs >= 500L) {
            this.dynamnicContext.resetRender();
        }
        lastRenderMs = System.currentTimeMillis();
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
            if (this.dynamnicContext.getShiftSnap() == -1L) {
                this.dynamnicContext.snapSamples();
            }
        } else {
            this.dynamnicContext.releaseSamples();
        }
        if (this.dynamnicContext.doesRenderIn3D()) {
            if (this.isMouseOver(mouseX, mouseY, recipeWidth, recipeHeight) && Mouse.isButtonDown((int)0)) {
                this.dynamnicContext.rotateRender(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
            }
        } else if (this.isMouseOver(mouseX, mouseY, recipeWidth, recipeHeight) && Mouse.isButtonDown((int)0)) {
            this.dynamnicContext.moveRender(0.25 * (double)Mouse.getDX(), 0.0, -0.25 * (double)Mouse.getDY());
        }
        if (this.isMouseOver(mouseX, mouseY, recipeWidth, recipeHeight)) {
            int dwheel = ClientMouseJEIGuiEventHandler.eventDWheelState;
            if (dwheel < 0) {
                this.dynamnicContext.zoomOut();
            } else if (dwheel > 0) {
                this.dynamnicContext.zoomIn();
            }
            ClientMouseJEIGuiEventHandler.eventDWheelState = 0;
        }
        ScaledResolution res = new ScaledResolution(minecraft);
        RecipeLayout recipeLayout = StructurePreviewWrapper.getCurrentLayout(minecraft, this);
        int recipeY = recipeLayout != null ? recipeLayout.getPosY() : 0;
        int guiLeft = (current.field_146294_l - recipeWidth) / 2;
        int guiTop = res.func_78328_b() - recipeY - recipeHeight + 38;
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((guiLeft + 4) * res.func_78325_e()), (int)(guiTop * res.func_78325_e()), (int)(160 * res.func_78325_e()), (int)(94 * res.func_78325_e()));
        int x = 88;
        int z = 64;
        GlStateManager.func_179147_l();
        this.dynamnicContext.renderAt(x, z);
        GL11.glDisable((int)3089);
        this.drawButtons(minecraft, mouseX, mouseY, 0, 0, recipeWidth, recipeHeight);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.machine.getModifiers().isEmpty()) {
            minecraft.func_110434_K().func_110577_a(TEXTURE_BACKGROUND);
            this.drawableUpgradesHover.draw(minecraft, 5, 124);
            GlStateManager.func_179097_i();
            reqBlueprint = I18n.func_135052_a((String)"tooltip.machinery.blueprint.upgrades", (Object[])new Object[0]);
            minecraft.field_71466_p.func_78276_b(reqBlueprint, 10, 127, 0x444444);
            GlStateManager.func_179126_j();
            if (mouseX >= 5 && mouseX <= 105 && mouseY >= 124 && mouseY <= 139) {
                LinkedList<Tuple<ItemStack, String>> descriptionList = new LinkedList<Tuple<ItemStack, String>>();
                boolean first = true;
                for (List<ModifierReplacement> modifiers : this.machine.getModifiers().values()) {
                    for (ModifierReplacement mod : modifiers) {
                        if (!first) {
                            descriptionList.add((Tuple<ItemStack, String>)new Tuple((Object)ItemStack.field_190927_a, (Object)""));
                        }
                        first = false;
                        ItemStack stack = mod.getBlockInformation().getDescriptiveStack(this.dynamnicContext.getShiftSnap() == -1L ? Optional.empty() : Optional.of(this.dynamnicContext.getShiftSnap()));
                        List tooltip = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                        descriptionList.add((Tuple<ItemStack, String>)new Tuple((Object)stack, Iterables.getFirst((Iterable)tooltip, (Object)"")));
                        for (String str : mod.getDescriptionLines()) {
                            descriptionList.add((Tuple<ItemStack, String>)new Tuple((Object)ItemStack.field_190927_a, (Object)str));
                        }
                    }
                }
                RenderingUtils.renderBlueStackTooltip(mouseX, mouseY, descriptionList, minecraft.field_71466_p, Minecraft.func_71410_x().func_175599_af());
            }
        }
        minecraft.field_71466_p.func_78276_b(this.machine.getLocalizedName(), 4, 0, 0x222222);
        if (this.machine.requiresBlueprint()) {
            reqBlueprint = I18n.func_135052_a((String)"tooltip.machinery.blueprint.required", (Object[])new Object[0]);
            minecraft.field_71466_p.func_78276_b(reqBlueprint, 6, 102, 0x222222);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Rectangle scissorFrame = new Rectangle(4, 4, 160, 94);
        if (!this.dynamnicContext.doesRenderIn3D() && scissorFrame.contains(mouseX, mouseY)) {
            double scale = this.dynamnicContext.getScale();
            Vec2f offset = this.dynamnicContext.getCurrentRenderOffset(x, z);
            int jumpWidth = 14;
            double scaleJump = (double)jumpWidth * scale;
            Map<BlockPos, BlockArray.BlockInformation> slice = this.machine.getPattern().getPatternSlice(this.dynamnicContext.getRenderSlice());
            if (this.dynamnicContext.getRenderSlice() == 0) {
                slice.put(BlockPos.field_177992_a, new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{new BlockArray.IBlockStateDescriptor(BlocksMM.blockController.func_176223_P())})));
            }
            for (BlockPos pos : slice.keySet()) {
                int zMod;
                int xMod = pos.func_177958_n() + 1;
                Rectangle2D.Double rct = new Rectangle2D.Double((double)offset.field_189982_i - (double)xMod * scaleJump, (double)offset.field_189983_j - (double)(zMod = pos.func_177952_p() + 1) * scaleJump, scaleJump, scaleJump);
                if (!rct.contains(mouseX, mouseY)) continue;
                BlockArray.BlockInformation bi = slice.get(pos);
                IBlockState state = bi.getSampleState(this.dynamnicContext.getShiftSnap() == -1L ? Optional.empty() : Optional.of(this.dynamnicContext.getShiftSnap()));
                Tuple<IBlockState, TileEntity> recovered = BlockCompatHelper.transformState(state, bi.matchingTag, new BlockArray.TileInstantiateContext((World)Minecraft.func_71410_x().field_71441_e, pos));
                state = (IBlockState)recovered.func_76341_a();
                Block type = state.func_177230_c();
                int meta = type.func_176201_c(state);
                ItemStack s = ItemStack.field_190927_a;
                try {
                    s = ic2TileBlock.equals((Object)type.getRegistryName()) ? BlockCompatHelper.tryGetIC2MachineStack(state, recovered.func_76340_b()) : state.func_177230_c().getPickBlock(state, null, null, pos, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (s.func_190926_b()) {
                    if (type instanceof BlockFluidBase) {
                        s = FluidUtil.getFilledBucket((FluidStack)new FluidStack(((BlockFluidBase)type).getFluid(), 1000));
                    } else if (type instanceof BlockLiquid) {
                        Material m = state.func_185904_a();
                        s = m == Material.field_151586_h ? new ItemStack(Items.field_151131_as) : (m == Material.field_151587_i ? new ItemStack(Items.field_151129_at) : ItemStack.field_190927_a);
                    } else {
                        Item i = Item.func_150898_a((Block)type);
                        if (i == Items.field_190931_a) continue;
                        s = i.func_77614_k() ? new ItemStack(i, 1, meta) : new ItemStack(i);
                    }
                }
                if (s.func_190926_b()) break;
                List tooltip = s.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                LinkedList<Tuple<ItemStack, String>> stacks = new LinkedList<Tuple<ItemStack, String>>();
                boolean first = true;
                for (String str : tooltip) {
                    if (first) {
                        stacks.add(new Tuple((Object)s, (Object)str));
                        first = false;
                        continue;
                    }
                    stacks.add(new Tuple((Object)ItemStack.field_190927_a, (Object)str));
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)mouseX, (float)mouseY, (float)0.0f);
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                RenderingUtils.renderBlueStackTooltip(0, 0, stacks, Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_175599_af());
                GlStateManager.func_179147_l();
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
                break;
            }
        }
    }

    private void drawButtons(Minecraft minecraft, int mouseX, int mouseY, int guiLeft, int guiTop, int recipeWidth, int recipeHeight) {
        if (this.dynamnicContext == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        minecraft.func_110434_K().func_110577_a(TEXTURE_BACKGROUND);
        boolean drawPopoutInfo = false;
        boolean drawContents = false;
        IDrawable drawable = this.drawable3DDisabled;
        if (!this.dynamnicContext.doesRenderIn3D()) {
            if (mouseX >= guiLeft + 132 && mouseX <= guiLeft + 132 + 16 && mouseY >= guiTop + 106 && mouseY < guiTop + 106 + 16) {
                drawable = this.drawable3DHover;
            }
        } else {
            drawable = this.drawable3DActive;
        }
        drawable.draw(minecraft, guiLeft + 132, guiTop + 106);
        drawable = this.drawablePopOutDisabled;
        if (mouseX >= guiLeft + 116 && mouseX <= guiLeft + 116 + 16 && mouseY >= guiTop + 106 && mouseY < guiTop + 106 + 16) {
            if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
                drawable = this.drawablePopOutHover;
            }
            drawPopoutInfo = true;
        }
        drawable.draw(minecraft, guiLeft + 116, guiTop + 106);
        drawable = this.drawable2DDisabled;
        if (this.dynamnicContext.doesRenderIn3D()) {
            if (mouseX >= guiLeft + 132 && mouseX <= guiLeft + 132 + 16 && mouseY >= guiTop + 122 && mouseY <= guiTop + 122 + 16) {
                drawable = this.drawable2DHover;
            }
        } else {
            drawable = this.drawable2DActive;
        }
        drawable.draw(minecraft, guiLeft + 132, guiTop + 122);
        drawable = this.drawableContentsDisabled;
        if (mouseX >= guiLeft + 116 && mouseX <= guiLeft + 116 + 16 && mouseY >= guiTop + 122 && mouseY <= guiTop + 122 + 16) {
            drawable = this.drawableContentsHover;
            drawContents = true;
        }
        drawable.draw(minecraft, guiLeft + 116, guiTop + 122);
        if (this.dynamnicContext.doesRenderIn3D()) {
            GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.dynamnicContext.hasSliceUp()) {
            if (!this.dynamnicContext.doesRenderIn3D() && mouseX >= guiLeft + 150 && mouseX <= guiLeft + 150 + 16 && mouseY >= guiTop + 102 && mouseY <= guiTop + 102 + 16) {
                GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)1.0f, (float)1.0f);
            }
            this.drawableArrowUp.draw(minecraft, guiLeft + 150, guiTop + 102);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.dynamnicContext.hasSliceDown()) {
            if (!this.dynamnicContext.doesRenderIn3D() && mouseX >= guiLeft + 150 && mouseX <= guiLeft + 150 + 16 && mouseY >= guiTop + 124 && mouseY <= guiTop + 124 + 16) {
                GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)1.0f, (float)1.0f);
            }
            this.drawableArrowDown.draw(minecraft, guiLeft + 150, guiTop + 124);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = minecraft.field_71466_p.func_78256_a(String.valueOf(this.dynamnicContext.getRenderSlice()));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.0);
        minecraft.field_71466_p.func_78276_b(String.valueOf(this.dynamnicContext.getRenderSlice()), guiLeft + 158 - width / 2, guiTop + 118, 0x222222);
        if (drawPopoutInfo) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            List out = minecraft.field_71466_p.func_78271_c(I18n.func_135052_a((String)"gui.blueprint.popout.info", (Object[])new Object[0]), Math.min(res.func_78326_a() - mouseX, 200));
            RenderingUtils.renderBlueTooltip(mouseX, mouseY, out, minecraft.field_71466_p);
        }
        if (drawContents) {
            List<ItemStack> contents = this.dynamnicContext.getDescriptiveStacks();
            ArrayList contentMap = Lists.newArrayList();
            ItemStack ctrl = new ItemStack((Block)BlocksMM.blockController);
            contentMap.add(new Tuple((Object)ctrl, (Object)("1x " + (String)Iterables.getFirst((Iterable)ctrl.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), (Object)""))));
            for (ItemStack stack : contents) {
                contentMap.add(new Tuple((Object)stack, (Object)(stack.func_190916_E() + "x " + (String)Iterables.getFirst((Iterable)stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), (Object)""))));
            }
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
            int srWidth = scaledresolution.func_78326_a();
            int srHeight = scaledresolution.func_78328_b();
            int rMouseX = Mouse.getX() * srWidth / Minecraft.func_71410_x().field_71443_c;
            int rMouseY = srHeight - Mouse.getY() * srHeight / Minecraft.func_71410_x().field_71440_d - 1;
            RecipesGui current = (RecipesGui)Minecraft.func_71410_x().field_71462_r;
            RecipeLayout currentLayout = null;
            try {
                List layoutList = (List)layouts.get(current);
                for (RecipeLayout layout : layoutList) {
                    if (!layout.isMouseOver(rMouseX, rMouseY)) continue;
                    currentLayout = layout;
                    break;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (currentLayout != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-currentLayout.getPosX()), (float)(-currentLayout.getPosY()), (float)0.0f);
                RenderingUtils.renderBlueStackTooltip(currentLayout.getPosX() + mouseX, currentLayout.getPosY() + mouseY, contentMap, minecraft.field_71466_p, minecraft.func_175599_af());
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack bOut = new ItemStack((Item)ItemsMM.blueprint);
        ItemBlueprint.setAssociatedMachine(bOut, this.machine);
        ingredients.setOutput(ItemStack.class, (Object)bOut);
    }

    private boolean isMouseOver(int mouseX, int mouseY, int width, int height) {
        return 0 < mouseX && mouseX < width && 0 < mouseY && mouseY < height;
    }

    public static RecipeLayout getCurrentLayout(Minecraft minecraft, IRecipeWrapper wrapper) {
        if (minecraft.field_71462_r instanceof RecipesGui) {
            try {
                List recipesRendering = (List)layouts.get((RecipesGui)minecraft.field_71462_r);
                for (RecipeLayout recipeLayout : recipesRendering) {
                    if (!recipeLayoutWrapper.get(recipeLayout).equals(wrapper)) continue;
                    return recipeLayout;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        Field f;
        ic2TileBlock = new ResourceLocation("ic2", "te");
        TEXTURE_BACKGROUND = new ResourceLocation("modularmachinery", "textures/gui/guiblueprint_jei.png");
        lastRenderMs = 0L;
        try {
            f = RecipesGui.class.getDeclaredField("recipeLayouts");
            f.setAccessible(true);
        }
        catch (Exception exc) {
            f = null;
        }
        layouts = f;
        try {
            f = RecipeLayout.class.getDeclaredField("recipeWrapper");
            f.setAccessible(true);
        }
        catch (Exception exc) {
            f = null;
        }
        recipeLayoutWrapper = f;
    }
}

