/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementFluid;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraftforge.fml.common.Optional;

public class ComponentGas
extends ComponentType {
    @Override
    @Nonnull
    public String getRegistryName() {
        return "gas";
    }

    @Override
    @Nullable
    public String requiresModid() {
        return "mekanism";
    }

    @Nonnull
    public ComponentRequirement provideComponent(MachineComponent.IOType machineIoType, JsonObject jsonObject) {
        return this.provideMekGasComponent(machineIoType, jsonObject);
    }

    @Nonnull
    @Optional.Method(modid="mekanism")
    private ComponentRequirement provideMekGasComponent(MachineComponent.IOType machineIoType, JsonObject requirement) {
        if (!(requirement.has("gas") && requirement.get("gas").isJsonPrimitive() && requirement.get("gas").getAsJsonPrimitive().isString())) {
            throw new JsonParseException("The ComponentType 'gas' expects an 'gas'-entry that defines the type of gas!");
        }
        if (!(requirement.has("amount") && requirement.get("amount").isJsonPrimitive() && requirement.get("amount").getAsJsonPrimitive().isNumber())) {
            throw new JsonParseException("The ComponentType 'gas' expects an 'amount'-entry that defines the type of gas!");
        }
        String gasName = requirement.getAsJsonPrimitive("gas").getAsString();
        int mbAmount = requirement.getAsJsonPrimitive("amount").getAsInt();
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas == null) {
            throw new JsonParseException("The gas specified in the 'gas'-entry (" + gasName + ") doesn't exist!");
        }
        mbAmount = Math.max(0, mbAmount);
        GasStack gasStack = new GasStack(gas, mbAmount);
        RequirementFluid req = RequirementFluid.createMekanismGasRequirement(ComponentType.Registry.getComponent("gas"), machineIoType, gasStack);
        if (requirement.has("chance")) {
            if (!requirement.get("chance").isJsonPrimitive() || !requirement.getAsJsonPrimitive("chance").isNumber()) {
                throw new JsonParseException("'chance', if defined, needs to be a chance-number between 0 and 1!");
            }
            float chance = requirement.getAsJsonPrimitive("chance").getAsFloat();
            if (chance >= 0.0f && chance <= 1.0f) {
                req.setChance(chance);
            }
        }
        return req;
    }
}

