/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirements;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirements.jei.JEIComponentHybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidGas;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.CopyHandlerHelper;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import hellfirepvp.modularmachinery.common.util.nbt.NBTMatchingHelper;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class RequirementFluid
extends ComponentRequirement<HybridFluid>
implements ComponentRequirement.ChancedRequirement {
    public final HybridFluid required;
    public float chance = 1.0f;
    private HybridFluid requirementCheck;
    private boolean doesntConsumeInput;
    private NBTTagCompound tagMatch = null;
    private NBTTagCompound tagDisplay = null;

    public RequirementFluid(ComponentType<?> type, MachineComponent.IOType ioType, FluidStack fluid) {
        super(type, ioType);
        this.required = new HybridFluid(fluid);
        this.requirementCheck = this.required.copy();
    }

    private RequirementFluid(ComponentType<?> type, MachineComponent.IOType ioType, HybridFluid required) {
        super(type, ioType);
        this.required = required.copy();
        this.requirementCheck = this.required.copy();
    }

    @Optional.Method(modid="mekanism")
    public static RequirementFluid createMekanismGasRequirement(ComponentType<?> type, MachineComponent.IOType ioType, GasStack gasStack) {
        return new RequirementFluid(type, ioType, new HybridFluidGas(gasStack));
    }

    @Override
    public ComponentRequirement<HybridFluid> deepCopy() {
        RequirementFluid fluid = new RequirementFluid(this.getRequiredComponentType(), this.getActionType(), this.required);
        fluid.chance = this.chance;
        fluid.tagMatch = this.tagMatch;
        fluid.tagDisplay = this.tagDisplay;
        return fluid;
    }

    @Override
    public ComponentRequirement.JEIComponent<HybridFluid> provideJEIComponent() {
        return new JEIComponentHybridFluid(this);
    }

    public void setMatchNBTTag(@Nullable NBTTagCompound tag) {
        this.tagMatch = tag;
    }

    @Nullable
    public NBTTagCompound getTagMatch() {
        if (this.tagMatch == null) {
            return null;
        }
        return this.tagMatch.func_74737_b();
    }

    public void setDisplayNBTTag(@Nullable NBTTagCompound tag) {
        this.tagDisplay = tag;
    }

    @Nullable
    public NBTTagCompound getTagDisplay() {
        if (this.tagDisplay == null) {
            return null;
        }
        return this.tagDisplay.func_74737_b();
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
        this.requirementCheck = this.required.copy();
        this.requirementCheck.setAmount(Math.round(context.applyModifiers(this, this.getActionType(), (float)this.requirementCheck.getAmount(), false)));
        this.doesntConsumeInput = contextChance.canProduce(context.applyModifiers(this, this.getActionType(), this.chance, true));
    }

    @Override
    public void endRequirementCheck() {
        this.requirementCheck = this.required.copy();
        this.doesntConsumeInput = true;
    }

    @Override
    public ComponentRequirement.CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        if (!component.getComponentType().getRegistryName().equals("fluid") && !component.getComponentType().getRegistryName().equals("gas") || !(component instanceof MachineComponent.FluidHatch) || component.getIOType() != this.getActionType()) {
            return ComponentRequirement.CraftCheck.INVALID_SKIP;
        }
        HybridTank handler = (HybridTank)((Object)context.getProvidedCraftingComponent(component));
        if (ModularMachinery.isMekanismLoaded) {
            return this.checkStartCraftingWithMekanism(component, context, handler, restrictions);
        }
        switch (this.getActionType()) {
            case INPUT: {
                FluidStack drained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
                if (drained == null) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drained.tag)) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drained.amount, 0));
                if (this.requirementCheck.getAmount() > 0) break;
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
            case OUTPUT: {
                boolean didFill;
                handler = CopyHandlerHelper.copyTank(handler);
                for (ComponentOutputRestrictor restrictor : restrictions) {
                    if (!(restrictor instanceof ComponentOutputRestrictor.RestrictionTank)) continue;
                    ComponentOutputRestrictor.RestrictionTank tank = (ComponentOutputRestrictor.RestrictionTank)restrictor;
                    if (!tank.exactComponent.equals(component)) continue;
                    handler.fillInternal(tank.inserted == null ? null : tank.inserted.copy().asFluidStack(), true);
                }
                int filled = handler.fillInternal(this.requirementCheck.copy().asFluidStack(), false);
                boolean bl = didFill = filled >= this.requirementCheck.getAmount();
                if (didFill) {
                    context.addRestriction(new ComponentOutputRestrictor.RestrictionTank(this.requirementCheck.copy(), component));
                }
                if (!didFill) break;
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
    }

    @Optional.Method(modid="mekanism")
    private ComponentRequirement.CraftCheck checkStartCraftingWithMekanism(MachineComponent component, RecipeCraftingContext context, HybridTank handler, List<ComponentOutputRestrictor> restrictions) {
        ComponentOutputRestrictor.RestrictionTank tank;
        if (handler instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)handler;
            switch (this.getActionType()) {
                case INPUT: {
                    if (!(this.requirementCheck instanceof HybridFluidGas)) break;
                    GasStack drained = gasTank.drawGas(EnumFacing.UP, this.requirementCheck.getAmount(), false);
                    if (drained == null) {
                        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                    }
                    if (drained.getGas() != ((HybridFluidGas)this.requirementCheck).asGasStack().getGas()) {
                        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                    }
                    this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drained.amount, 0));
                    if (this.requirementCheck.getAmount() > 0) break;
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                case OUTPUT: {
                    boolean didFill;
                    if (!(this.requirementCheck instanceof HybridFluidGas)) break;
                    gasTank = (HybridGasTank)CopyHandlerHelper.copyTank(gasTank);
                    for (ComponentOutputRestrictor restrictor : restrictions) {
                        if (!(restrictor instanceof ComponentOutputRestrictor.RestrictionTank)) continue;
                        tank = (ComponentOutputRestrictor.RestrictionTank)restrictor;
                        if (!tank.exactComponent.equals(component) || !(tank.inserted instanceof HybridFluidGas)) continue;
                        gasTank.receiveGas(EnumFacing.UP, ((HybridFluidGas)this.requirementCheck).asGasStack(), true);
                    }
                    int gasFilled = gasTank.receiveGas(EnumFacing.UP, ((HybridFluidGas)this.requirementCheck).asGasStack(), false);
                    boolean bl = didFill = gasFilled >= this.requirementCheck.getAmount();
                    if (didFill) {
                        context.addRestriction(new ComponentOutputRestrictor.RestrictionTank(this.requirementCheck.copy(), component));
                    }
                    if (!didFill) break;
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
            }
        }
        switch (this.getActionType()) {
            case INPUT: {
                FluidStack drained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
                if (drained == null) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drained.tag)) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drained.amount, 0));
                if (this.requirementCheck.getAmount() > 0) break;
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
            case OUTPUT: {
                boolean didFill;
                handler = CopyHandlerHelper.copyTank(handler);
                for (ComponentOutputRestrictor restrictor : restrictions) {
                    if (!(restrictor instanceof ComponentOutputRestrictor.RestrictionTank)) continue;
                    tank = (ComponentOutputRestrictor.RestrictionTank)restrictor;
                    if (!tank.exactComponent.equals(component) || tank.inserted instanceof HybridFluidGas) continue;
                    handler.fillInternal(tank.inserted == null ? null : tank.inserted.copy().asFluidStack(), true);
                }
                int filled = handler.fillInternal(this.requirementCheck.copy().asFluidStack(), false);
                boolean bl = didFill = filled >= this.requirementCheck.getAmount();
                if (didFill) {
                    context.addRestriction(new ComponentOutputRestrictor.RestrictionTank(this.requirementCheck.copy(), component));
                }
                if (!didFill) break;
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
    }

    @Override
    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (!component.getComponentType().getRegistryName().equals("fluid") && !component.getComponentType().getRegistryName().equals("gas") || !(component instanceof MachineComponent.FluidHatch) || component.getIOType() != this.getActionType()) {
            return false;
        }
        HybridTank handler = (HybridTank)((Object)context.getProvidedCraftingComponent(component));
        switch (this.getActionType()) {
            case INPUT: {
                if (ModularMachinery.isMekanismLoaded) {
                    return this.startCraftingWithMekanismHandling(handler, chance);
                }
                FluidStack drainedSimulated = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
                if (drainedSimulated == null) {
                    return false;
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drainedSimulated.tag)) {
                    return false;
                }
                if (this.doesntConsumeInput) {
                    this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drainedSimulated.amount, 0));
                    return this.requirementCheck.getAmount() <= 0;
                }
                FluidStack actualDrained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), true);
                if (actualDrained == null) {
                    return false;
                }
                if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, actualDrained.tag)) {
                    return false;
                }
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - actualDrained.amount, 0));
                return this.requirementCheck.getAmount() <= 0;
            }
        }
        return false;
    }

    @Optional.Method(modid="mekanism")
    private boolean startCraftingWithMekanismHandling(HybridTank handler, ResultChance chance) {
        if (this.requirementCheck instanceof HybridFluidGas && handler instanceof HybridGasTank) {
            HybridGasTank gasHandler = (HybridGasTank)handler;
            GasStack drainSimulated = gasHandler.drawGas(EnumFacing.UP, this.requirementCheck.getAmount(), false);
            if (drainSimulated == null) {
                return false;
            }
            if (drainSimulated.getGas() != ((HybridFluidGas)this.requirementCheck).asGasStack().getGas()) {
                return false;
            }
            if (this.doesntConsumeInput) {
                this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drainSimulated.amount, 0));
                return this.requirementCheck.getAmount() <= 0;
            }
            GasStack actualDrain = gasHandler.drawGas(EnumFacing.UP, this.requirementCheck.getAmount(), true);
            if (actualDrain == null) {
                return false;
            }
            if (actualDrain.getGas() != ((HybridFluidGas)this.requirementCheck).asGasStack().getGas()) {
                return false;
            }
            this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - actualDrain.amount, 0));
            return this.requirementCheck.getAmount() <= 0;
        }
        FluidStack drainedSimulated = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), false);
        if (drainedSimulated == null) {
            return false;
        }
        if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, drainedSimulated.tag)) {
            return false;
        }
        if (this.doesntConsumeInput) {
            this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - drainedSimulated.amount, 0));
            return this.requirementCheck.getAmount() <= 0;
        }
        FluidStack actualDrained = handler.drainInternal(this.requirementCheck.copy().asFluidStack(), true);
        if (actualDrained == null) {
            return false;
        }
        if (!NBTMatchingHelper.matchNBTCompound(this.tagMatch, actualDrained.tag)) {
            return false;
        }
        this.requirementCheck.setAmount(Math.max(this.requirementCheck.getAmount() - actualDrained.amount, 0));
        return this.requirementCheck.getAmount() <= 0;
    }

    @Override
    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (!component.getComponentType().getRegistryName().equals("fluid") && !component.getComponentType().getRegistryName().equals("gas") || !(component instanceof MachineComponent.FluidHatch) || component.getIOType() != this.getActionType()) {
            return false;
        }
        HybridTank handler = (HybridTank)((Object)context.getProvidedCraftingComponent(component));
        switch (this.getActionType()) {
            case OUTPUT: {
                if (ModularMachinery.isMekanismLoaded) {
                    return this.finishWithMekanismHandling(handler, chance);
                }
                FluidStack outStack = this.requirementCheck.asFluidStack();
                if (outStack == null) break;
                int fillableAmount = handler.fillInternal(outStack.copy(), false);
                if (chance.canProduce(this.chance)) {
                    return fillableAmount >= outStack.amount;
                }
                FluidStack copyOut = outStack.copy();
                if (this.tagDisplay != null) {
                    copyOut.tag = this.tagDisplay.func_74737_b();
                }
                return fillableAmount >= outStack.amount && handler.fillInternal(copyOut.copy(), true) >= copyOut.amount;
            }
        }
        return false;
    }

    @Optional.Method(modid="mekanism")
    private boolean finishWithMekanismHandling(HybridTank handler, ResultChance chance) {
        if (this.requirementCheck instanceof HybridFluidGas && handler instanceof HybridGasTank) {
            GasStack gasOut = ((HybridFluidGas)this.requirementCheck).asGasStack();
            HybridGasTank gasTankHandler = (HybridGasTank)handler;
            int fillableGas = gasTankHandler.receiveGas(EnumFacing.UP, gasOut, false);
            if (chance.canProduce(this.chance)) {
                return fillableGas >= gasOut.amount;
            }
            return fillableGas >= gasOut.amount && gasTankHandler.receiveGas(EnumFacing.UP, gasOut, true) >= gasOut.amount;
        }
        FluidStack outStack = this.requirementCheck.asFluidStack();
        if (outStack != null) {
            int fillableAmount = handler.fillInternal(outStack.copy(), false);
            if (chance.canProduce(this.chance)) {
                return fillableAmount >= outStack.amount;
            }
            FluidStack copyOut = outStack.copy();
            if (this.tagDisplay != null) {
                copyOut.tag = this.tagDisplay.func_74737_b();
            }
            return fillableAmount >= outStack.amount && handler.fillInternal(copyOut.copy(), true) >= copyOut.amount;
        }
        return false;
    }
}

