/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block;

import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.block.BlockCustomName;
import hellfirepvp.modularmachinery.common.block.BlockMachineComponent;
import hellfirepvp.modularmachinery.common.block.BlockVariants;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchSize;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyOutputHatch;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.util.RedstoneHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnergyOutputHatch
extends BlockMachineComponent
implements BlockCustomName,
BlockVariants {
    private static final PropertyEnum<EnergyHatchSize> BUS_TYPE = PropertyEnum.func_177709_a((String)"size", EnergyHatchSize.class);

    public BlockEnergyOutputHatch() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(CommonProxy.creativeTabModularMachinery);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnergyHatchSize size : EnergyHatchSize.values()) {
            items.add((Object)new ItemStack((Block)this, 1, size.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        EnergyHatchSize size = EnergyHatchSize.values()[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(EnergyHatchSize.values().length - 1))];
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.energyhatch.storage", (Object[])new Object[]{size.maxEnergy}));
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.energyhatch.out.transfer", (Object[])new Object[]{size.transferLimit}));
        if (Loader.isModLoaded((String)"ic2")) {
            tooltip.add("");
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.energyhatch.ic2.out.voltage", (Object[])new Object[]{TextFormatting.BLUE + I18n.func_135052_a((String)size.getUnlocalizedEnergyDescriptor(), (Object[])new Object[0])}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.energyhatch.ic2.out.transfer", (Object[])new Object[]{TextFormatting.BLUE + String.valueOf(size.getEnergyTransmission()), TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.energyhatch.ic2.powerrate", (Object[])new Object[0])}));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileEnergyHatch) {
            playerIn.openGui((Object)"modularmachinery", CommonProxy.GuiType.ENERGY_INVENTORY.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BUS_TYPE, (Comparable)((Object)EnergyHatchSize.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnergyHatchSize)((Object)state.func_177229_b(BUS_TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BUS_TYPE});
    }

    @Override
    public Iterable<IBlockState> getValidStates() {
        LinkedList<IBlockState> ret = new LinkedList<IBlockState>();
        for (EnergyHatchSize type : EnergyHatchSize.values()) {
            ret.add(this.func_176223_P().func_177226_a(BUS_TYPE, (Comparable)((Object)type)));
        }
        return ret;
    }

    @Override
    public String getBlockStateName(IBlockState state) {
        return ((EnergyHatchSize)((Object)state.func_177229_b(BUS_TYPE))).func_176610_l();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return RedstoneHelper.getRedstoneLevel(worldIn.func_175625_s(pos));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEnergyOutputHatch((EnergyHatchSize)((Object)state.func_177229_b(BUS_TYPE)));
    }

    @Override
    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        return ((EnergyHatchSize)((Object)this.func_176203_a(meta).func_177229_b(BUS_TYPE))).func_176610_l();
    }
}

