/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common;

import hellfirepvp.modularmachinery.common.container.ContainerController;
import hellfirepvp.modularmachinery.common.container.ContainerEnergyHatch;
import hellfirepvp.modularmachinery.common.container.ContainerFluidHatch;
import hellfirepvp.modularmachinery.common.container.ContainerItemBus;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapterRegistry;
import hellfirepvp.modularmachinery.common.data.ModDataHolder;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationCrafttweaker;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.registry.RegistrationBus;
import hellfirepvp.modularmachinery.common.registry.RegistryBlocks;
import hellfirepvp.modularmachinery.common.registry.RegistryItems;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.tiles.base.TileFluidTank;
import hellfirepvp.modularmachinery.common.tiles.base.TileItemBus;
import hellfirepvp.modularmachinery.common.util.FuelItemHelper;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class CommonProxy
implements IGuiHandler {
    public static CreativeTabs creativeTabModularMachinery;
    public static ModDataHolder dataHolder;

    public void loadModData(File configDir) {
        dataHolder.setup(configDir);
        if (dataHolder.requiresDefaultMachinery()) {
            dataHolder.copyDefaultMachinery();
        }
    }

    public void preInit() {
        creativeTabModularMachinery = new CreativeTabs("modularmachinery"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)BlocksMM.blockController);
            }
        };
        MachineRegistry.getRegistry().buildRegistry();
        RecipeRegistry.getRegistry().buildRegistry();
        MinecraftForge.EVENT_BUS.register((Object)new RegistrationBus());
        RegistryBlocks.initialize();
        RegistryItems.initialize();
        ComponentType.Registry.initialize();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"modularmachinery", (IGuiHandler)this);
        if (Loader.isModLoaded((String)"crafttweaker")) {
            MinecraftForge.EVENT_BUS.register((Object)new ModIntegrationCrafttweaker());
        }
    }

    public void init() {
        FuelItemHelper.initialize();
        RecipeAdapterRegistry.initDefaultAdapters();
        MachineRegistry.getRegistry().registerMachines(MachineRegistry.getRegistry().loadMachines(null));
        RecipeRegistry.getRegistry().registerRecipes(RecipeRegistry.getRegistry().loadRecipes(null));
    }

    public void postInit() {
    }

    public void registerBlockModel(Block block) {
    }

    public void registerItemModel(Item item) {
    }

    @Nullable
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiType type = GuiType.values()[MathHelper.func_76125_a((int)ID, (int)0, (int)(GuiType.values().length - 1))];
        Class<? extends TileEntity> required = type.requiredTileEntity;
        TileEntity present = null;
        if (required != null) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te != null && required.isAssignableFrom(te.getClass())) {
                present = te;
            } else {
                return null;
            }
        }
        switch (type) {
            case CONTROLLER: {
                return new ContainerController((TileMachineController)present, player);
            }
            case BUS_INVENTORY: {
                return new ContainerItemBus((TileItemBus)present, player);
            }
            case TANK_INVENTORY: {
                return new ContainerFluidHatch((TileFluidTank)present, player);
            }
            case ENERGY_INVENTORY: {
                return new ContainerEnergyHatch((TileEnergyHatch)present, player);
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    static {
        dataHolder = new ModDataHolder();
    }

    public static enum GuiType {
        CONTROLLER(TileMachineController.class),
        BUS_INVENTORY(TileItemBus.class),
        TANK_INVENTORY(TileFluidTank.class),
        ENERGY_INVENTORY(TileEnergyHatch.class),
        BLUEPRINT_PREVIEW(null);

        public final Class<? extends TileEntity> requiredTileEntity;

        private GuiType(Class<? extends TileEntity> requiredTileEntity) {
            this.requiredTileEntity = requiredTileEntity;
        }
    }
}

