/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.gui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.client.util.DynamicMachineRenderContext;
import hellfirepvp.modularmachinery.client.util.RenderingUtils;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockCompatHelper;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreenBlueprint
extends GuiScreen {
    private static final ResourceLocation ic2TileBlock = new ResourceLocation("ic2", "te");
    public static final ResourceLocation TEXTURE_BACKGROUND = new ResourceLocation("modularmachinery", "textures/gui/guiblueprint.png");
    protected int guiLeft;
    protected int guiTop;
    protected int xSize = 176;
    protected int ySize = 144;
    private final DynamicMachine machine;
    private final DynamicMachineRenderContext renderContext;
    private int frameCount = 0;

    public GuiScreenBlueprint(DynamicMachine machine) {
        this.machine = machine;
        this.renderContext = DynamicMachineRenderContext.createContext(this.machine);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String reqBlueprint;
        int dwheel;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ++this.frameCount;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_BACKGROUND);
        int x = (this.field_146294_l - this.xSize) / 2;
        int z = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, z, 0, 0, this.xSize, this.ySize);
        if (this.renderContext.doesRenderIn3D()) {
            if (Mouse.isButtonDown((int)0) && this.frameCount > 20) {
                this.renderContext.rotateRender(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
            }
        } else if (Mouse.isButtonDown((int)0) && this.frameCount > 20) {
            this.renderContext.moveRender(0.25 * (double)Mouse.getDX(), 0.0, -0.25 * (double)Mouse.getDY());
        }
        if ((dwheel = Mouse.getDWheel()) < 0) {
            this.renderContext.zoomOut();
        } else if (dwheel > 0) {
            this.renderContext.zoomIn();
        }
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
            if (this.renderContext.getShiftSnap() == -1L) {
                this.renderContext.snapSamples();
            }
        } else {
            this.renderContext.releaseSamples();
        }
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        Rectangle scissorFrame = new Rectangle((this.guiLeft + 8) * res.func_78325_e(), (this.guiTop + 43) * res.func_78325_e(), 160 * res.func_78325_e(), 94 * res.func_78325_e());
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorFrame.x, (int)scissorFrame.y, (int)scissorFrame.width, (int)scissorFrame.height);
        x = 88;
        z = 66;
        this.renderContext.renderAt(this.guiLeft + x, this.guiTop + z, partialTicks);
        GL11.glDisable((int)3089);
        this.drawButtons(mouseX, mouseY);
        if (!this.machine.getModifiers().isEmpty()) {
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_BACKGROUND);
            this.func_73729_b(this.guiLeft + 5, this.guiTop + 124, 0, 145, 100, 15);
            GlStateManager.func_179097_i();
            reqBlueprint = I18n.func_135052_a((String)"tooltip.machinery.blueprint.upgrades", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(reqBlueprint, this.guiLeft + 10, this.guiTop + 127, 0x444444);
            GlStateManager.func_179126_j();
            if (mouseX >= this.guiLeft + 5 && mouseX <= this.guiLeft + 105 && mouseY >= this.guiTop + 124 && mouseY <= this.guiTop + 139) {
                LinkedList<Tuple<ItemStack, String>> descriptionList = new LinkedList<Tuple<ItemStack, String>>();
                boolean first = true;
                for (List<ModifierReplacement> modifiers : this.machine.getModifiers().values()) {
                    for (ModifierReplacement mod : modifiers) {
                        if (!first) {
                            descriptionList.add((Tuple<ItemStack, String>)new Tuple((Object)ItemStack.field_190927_a, (Object)""));
                        }
                        first = false;
                        ItemStack stack = mod.getBlockInformation().getDescriptiveStack(this.renderContext.getShiftSnap() == -1L ? Optional.empty() : Optional.of(this.renderContext.getShiftSnap()));
                        List tooltip = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                        descriptionList.add((Tuple<ItemStack, String>)new Tuple((Object)stack, Iterables.getFirst((Iterable)tooltip, (Object)"")));
                        for (String str : mod.getDescriptionLines()) {
                            descriptionList.add((Tuple<ItemStack, String>)new Tuple((Object)ItemStack.field_190927_a, (Object)str));
                        }
                    }
                }
                RenderingUtils.renderBlueStackTooltip(mouseX, mouseY, descriptionList, this.field_146289_q, Minecraft.func_71410_x().func_175599_af());
            }
        }
        GlStateManager.func_179097_i();
        this.field_146289_q.func_175063_a(this.machine.getLocalizedName(), (float)(this.guiLeft + 10), (float)(this.guiTop + 11), -1);
        if (this.machine.requiresBlueprint()) {
            reqBlueprint = I18n.func_135052_a((String)"tooltip.machinery.blueprint.required", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(reqBlueprint, this.guiLeft + 10, this.guiTop + 106, 0x444444);
        }
        GlStateManager.func_179126_j();
        scissorFrame = new Rectangle(MathHelper.func_76141_d((float)(this.guiLeft + 8)), MathHelper.func_76141_d((float)(this.guiTop + 8)), 160, 94);
        if (!this.renderContext.doesRenderIn3D() && scissorFrame.contains(mouseX, mouseY)) {
            this.render2DHover(mouseX, mouseY, x, z);
        }
    }

    private void render2DHover(int mouseX, int mouseY, int x, int z) {
        double scale = this.renderContext.getScale();
        Vec2f offset = this.renderContext.getCurrentRenderOffset(this.guiLeft + x, this.guiTop + z);
        int jumpWidth = 14;
        double scaleJump = (double)jumpWidth * scale;
        Map<BlockPos, BlockArray.BlockInformation> slice = this.machine.getPattern().getPatternSlice(this.renderContext.getRenderSlice());
        if (this.renderContext.getRenderSlice() == 0) {
            slice.put(BlockPos.field_177992_a, new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{new BlockArray.IBlockStateDescriptor(BlocksMM.blockController.func_176223_P())})));
        }
        for (BlockPos pos : slice.keySet()) {
            int zMod;
            int xMod = pos.func_177958_n() + 1;
            Rectangle2D.Double rct = new Rectangle2D.Double((double)offset.field_189982_i - (double)xMod * scaleJump, (double)offset.field_189983_j - (double)(zMod = pos.func_177952_p() + 1) * scaleJump, scaleJump, scaleJump);
            if (!rct.contains(mouseX, mouseY)) continue;
            IBlockState state = slice.get(pos).getSampleState(this.renderContext.getShiftSnap() == -1L ? Optional.empty() : Optional.of(this.renderContext.getShiftSnap()));
            Tuple<IBlockState, TileEntity> recovered = BlockCompatHelper.transformState(state, slice.get((Object)pos).matchingTag, new BlockArray.TileInstantiateContext((World)Minecraft.func_71410_x().field_71441_e, pos));
            state = (IBlockState)recovered.func_76341_a();
            Block type = state.func_177230_c();
            int meta = type.func_176201_c(state);
            ItemStack s = ItemStack.field_190927_a;
            try {
                s = ic2TileBlock.equals((Object)type.getRegistryName()) ? BlockCompatHelper.tryGetIC2MachineStack(state, recovered.func_76340_b()) : state.func_177230_c().getPickBlock(state, null, null, pos, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (s.func_190926_b()) {
                if (type instanceof BlockFluidBase) {
                    s = FluidUtil.getFilledBucket((FluidStack)new FluidStack(((BlockFluidBase)type).getFluid(), 1000));
                } else if (type instanceof BlockLiquid) {
                    Material m = state.func_185904_a();
                    s = m == Material.field_151586_h ? new ItemStack(Items.field_151131_as) : (m == Material.field_151587_i ? new ItemStack(Items.field_151129_at) : ItemStack.field_190927_a);
                } else {
                    Item i = Item.func_150898_a((Block)type);
                    if (i == Items.field_190931_a) continue;
                    s = i.func_77614_k() ? new ItemStack(i, 1, meta) : new ItemStack(i);
                }
            }
            List tooltip = s.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            LinkedList<Tuple<ItemStack, String>> stacks = new LinkedList<Tuple<ItemStack, String>>();
            boolean first = true;
            for (String str : tooltip) {
                if (first) {
                    stacks.add(new Tuple((Object)s, (Object)str));
                    first = false;
                    continue;
                }
                stacks.add(new Tuple((Object)ItemStack.field_190927_a, (Object)str));
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)mouseX, (float)mouseY, (float)0.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            RenderingUtils.renderBlueStackTooltip(0, 0, stacks, Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_175599_af());
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
            break;
        }
    }

    private void drawButtons(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_BACKGROUND);
        boolean drawPopoutInfo = false;
        boolean drawContents = false;
        int add = 0;
        if (!this.renderContext.doesRenderIn3D()) {
            if (mouseX >= this.guiLeft + 132 && mouseX <= this.guiLeft + 132 + 16 && mouseY >= this.guiTop + 106 && mouseY < this.guiTop + 106 + 16) {
                add = 16;
            }
        } else {
            add = 32;
        }
        this.func_73729_b(this.guiLeft + 132, this.guiTop + 106, 176 + add, 16, 16, 16);
        add = 0;
        if (mouseX >= this.guiLeft + 116 && mouseX <= this.guiLeft + 116 + 16 && mouseY >= this.guiTop + 106 && mouseY < this.guiTop + 106 + 16) {
            if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
                add = 16;
            }
            drawPopoutInfo = true;
        }
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 106, 176 + add, 48, 16, 16);
        add = 0;
        if (this.renderContext.doesRenderIn3D()) {
            if (mouseX >= this.guiLeft + 132 && mouseX <= this.guiLeft + 132 + 16 && mouseY >= this.guiTop + 122 && mouseY <= this.guiTop + 122 + 16) {
                add = 16;
            }
        } else {
            add = 32;
        }
        this.func_73729_b(this.guiLeft + 132, this.guiTop + 122, 176 + add, 32, 16, 16);
        add = 0;
        if (mouseX >= this.guiLeft + 116 && mouseX <= this.guiLeft + 116 + 16 && mouseY >= this.guiTop + 122 && mouseY <= this.guiTop + 122 + 16) {
            add = 16;
            drawContents = true;
        }
        this.func_73729_b(this.guiLeft + 116, this.guiTop + 122, 176 + add, 64, 16, 16);
        if (this.renderContext.doesRenderIn3D()) {
            GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.renderContext.hasSliceUp()) {
            if (!this.renderContext.doesRenderIn3D() && mouseX >= this.guiLeft + 150 && mouseX <= this.guiLeft + 150 + 16 && mouseY >= this.guiTop + 102 && mouseY <= this.guiTop + 102 + 16) {
                GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)1.0f, (float)1.0f);
            }
            this.func_73729_b(this.guiLeft + 150, this.guiTop + 102, 192, 0, 16, 16);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.renderContext.hasSliceDown()) {
            if (!this.renderContext.doesRenderIn3D() && mouseX >= this.guiLeft + 150 && mouseX <= this.guiLeft + 150 + 16 && mouseY >= this.guiTop + 124 && mouseY <= this.guiTop + 124 + 16) {
                GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)1.0f, (float)1.0f);
            }
            this.func_73729_b(this.guiLeft + 150, this.guiTop + 124, 176, 0, 16, 16);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = this.field_146289_q.func_78256_a(String.valueOf(this.renderContext.getRenderSlice()));
        this.field_146289_q.func_78276_b(String.valueOf(this.renderContext.getRenderSlice()), this.guiLeft + 159 - width / 2, this.guiTop + 118, 0x222222);
        if (drawPopoutInfo) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            List out = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"gui.blueprint.popout.info", (Object[])new Object[0]), Math.min(res.func_78326_a() - mouseX, 200));
            RenderingUtils.renderBlueTooltip(mouseX, mouseY, out, this.field_146289_q);
        }
        if (drawContents) {
            List<ItemStack> contents = this.renderContext.getDescriptiveStacks();
            ArrayList contentMap = Lists.newArrayList();
            ItemStack ctrl = new ItemStack((Block)BlocksMM.blockController);
            contentMap.add(new Tuple((Object)ctrl, (Object)("1x " + (String)Iterables.getFirst((Iterable)ctrl.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), (Object)""))));
            for (ItemStack stack : contents) {
                contentMap.add(new Tuple((Object)stack, (Object)(stack.func_190916_E() + "x " + (String)Iterables.getFirst((Iterable)stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), (Object)""))));
            }
            RenderingUtils.renderBlueStackTooltip(mouseX, mouseY, contentMap, this.field_146289_q, Minecraft.func_71410_x().func_175599_af());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (!this.renderContext.doesRenderIn3D()) {
                if (mouseX >= this.guiLeft + 132 && mouseX <= this.guiLeft + 132 + 16 && mouseY >= this.guiTop + 106 && mouseY <= this.guiTop + 106 + 16) {
                    this.renderContext.setTo3D();
                }
                if (this.renderContext.hasSliceUp() && mouseX >= this.guiLeft + 150 && mouseX <= this.guiLeft + 150 + 16 && mouseY >= this.guiTop + 102 && mouseY <= this.guiTop + 102 + 16) {
                    this.renderContext.sliceUp();
                }
                if (this.renderContext.hasSliceDown() && mouseX >= this.guiLeft + 150 && mouseX <= this.guiLeft + 150 + 16 && mouseY >= this.guiTop + 124 && mouseY <= this.guiTop + 124 + 16) {
                    this.renderContext.sliceDown();
                }
            } else if (mouseX >= this.guiLeft + 132 && mouseX <= this.guiLeft + 132 + 16 && mouseY >= this.guiTop + 122 && mouseY <= this.guiTop + 122 + 16) {
                this.renderContext.setTo2D();
            }
            if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E) && mouseX >= this.guiLeft + 116 && mouseX <= this.guiLeft + 116 + 16 && mouseY >= this.guiTop + 106 && mouseY < this.guiTop + 106 + 16 && ClientProxy.renderHelper.startPreview(this.renderContext)) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        } else if (mouseButton == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }
}

