/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.ILaserTrackableFast;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineTiered;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockLaserTurret;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaserTurret
extends TileBaseElectricBlockWithInventory
implements IMultiBlock,
ISidedInventory,
IMachineSides {
    private final float RANGE = 15.0f;
    private final float METEOR_RANGE = 90.0f;
    private List<Entity> tracked = Lists.newArrayList();
    private List<String> players = Lists.newArrayList();
    private List<ResourceLocation> entities = Lists.newArrayList();
    private boolean initialisedMulti = false;
    private AxisAlignedBB renderAABB;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean active = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int targettedEntity = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int chargeLevel = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean blacklistMode = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetMeteors = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean alwaysIgnoreSpaceRace = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int priorityClosest = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int priorityLowestHealth = 2;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int priorityHighestHealth = 3;
    private UUID ownerUUID = null;
    private String ownerName = null;
    private SpaceRace ownerSpaceRace = null;
    @SideOnly(value=Side.CLIENT)
    public float pitch;
    @SideOnly(value=Side.CLIENT)
    public float yaw;
    @SideOnly(value=Side.CLIENT)
    public float targetPitch;
    @SideOnly(value=Side.CLIENT)
    public float targetYaw;
    @SideOnly(value=Side.CLIENT)
    public int timeSinceShot = -1;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityLaserTurret() {
        super("tile.laser_turret.name");
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.setOwnerUUID(this.ownerUUID);
    }

    public void setOwnerSpaceRace(SpaceRace spaceRace) {
        this.ownerSpaceRace = spaceRace;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K) {
            networkedList.add(this.players.size());
            networkedList.addAll(this.players);
            networkedList.add(this.entities.size());
            for (ResourceLocation res : this.entities) {
                networkedList.add(res.toString());
            }
            networkedList.add(this.ownerUUID != null);
            if (this.ownerUUID != null) {
                networkedList.add(this.ownerUUID.getMostSignificantBits());
                networkedList.add(this.ownerUUID.getLeastSignificantBits());
            }
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            this.players.clear();
            int playerSize = dataStream.readInt();
            for (int i = 0; i < playerSize; ++i) {
                this.players.add(ByteBufUtils.readUTF8String((ByteBuf)dataStream));
            }
            this.entities.clear();
            int entitySize = dataStream.readInt();
            for (int i = 0; i < entitySize; ++i) {
                this.entities.add(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)dataStream)));
            }
            if (dataStream.readBoolean()) {
                this.ownerUUID = new UUID(dataStream.readLong(), dataStream.readLong());
            }
        }
    }

    public void addPlayer(String player) {
        this.players.add(player);
    }

    public void addEntity(ResourceLocation entity) {
        this.entities.add(entity);
    }

    public void removePlayer(String player) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!this.players.get(i).equals(player)) continue;
            this.players.remove(i--);
        }
    }

    public void removeEntity(ResourceLocation entity) {
        for (int i = 0; i < this.entities.size(); ++i) {
            if (!this.entities.get(i).equals((Object)entity)) continue;
            this.entities.remove(i--);
        }
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public List<ResourceLocation> getEntities() {
        return this.entities;
    }

    public double getPacketRange() {
        return 25.0;
    }

    public void trackEntity(Entity entity) {
        if (!this.tracked.contains(entity)) {
            this.tracked.add(entity);
        }
    }

    private Entity updateTarget() {
        ArrayList list = Lists.newArrayList();
        if (this.storage.getEnergyStoredGC() > 1000.0f && !this.getDisabled(0) && !RedstoneUtil.isBlockReceivingRedstone((World)this.field_145850_b, (BlockPos)this.func_174877_v())) {
            for (int i = 0; i < this.tracked.size(); ++i) {
                boolean shouldTarget;
                Entity e = this.tracked.get(i);
                if (e.field_70128_L) {
                    this.tracked.remove(i--);
                    continue;
                }
                boolean bl = shouldTarget = !this.blacklistMode;
                if (e instanceof EntityPlayer) {
                    EntityPlayer toTargetPlayer = (EntityPlayer)e;
                    if (this.alwaysIgnoreSpaceRace && (toTargetPlayer.func_110124_au().equals(this.ownerUUID) || this.ownerSpaceRace != null && this.ownerSpaceRace.getPlayerNames().contains(toTargetPlayer.func_70005_c_()))) {
                        shouldTarget = false;
                    } else {
                        for (String player : this.players) {
                            if (!player.equalsIgnoreCase(e.func_70005_c_())) continue;
                            shouldTarget = !shouldTarget;
                        }
                    }
                } else {
                    ResourceLocation location = EntityList.func_191306_a(e.getClass());
                    if (location != null) {
                        for (ResourceLocation entity : this.entities) {
                            if (!location.equals((Object)entity)) continue;
                            shouldTarget = !shouldTarget;
                        }
                    }
                }
                if (!shouldTarget) continue;
                Vector3 vec = new Vector3(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
                vec.translate(new Vector3((double)(-((float)this.field_174879_c.func_177958_n() + 0.5f)), (double)(-((float)this.field_174879_c.func_177956_o() + 1.78f)), (double)(-((float)this.field_174879_c.func_177952_p() + 0.5f))));
                Vector3 vecNoHeight = vec.clone();
                vecNoHeight.y = 0.0;
                if (!(vec.getMagnitudeSquared() < 225.0) && (!this.targetMeteors || !(e instanceof EntityMeteor) || !(vecNoHeight.getMagnitudeSquared() < 8100.0)) || !(Math.asin(vec.clone().normalize().y) > -1.0471975511965976)) continue;
                if (e instanceof EntityLivingBase) {
                    list.add(new EntityEntrySortable((EntityLivingBase)e, vec.getMagnitude()));
                    continue;
                }
                if (!this.targetMeteors || !(e instanceof EntityMeteor)) continue;
                return e;
            }
        }
        list.sort((o1, o2) -> {
            if (this.priorityClosest < this.priorityHighestHealth && this.priorityClosest < this.priorityLowestHealth) {
                if (this.priorityLowestHealth < this.priorityHighestHealth) {
                    return ComparisonChain.start().compare(((EntityEntrySortable)o1).distance, ((EntityEntrySortable)o2).distance).compare(((EntityEntrySortable)o1).entity.func_110143_aJ(), ((EntityEntrySortable)o2).entity.func_110143_aJ()).result();
                }
                return ComparisonChain.start().compare(((EntityEntrySortable)o1).distance, ((EntityEntrySortable)o2).distance).compare(((EntityEntrySortable)o2).entity.func_110143_aJ(), ((EntityEntrySortable)o1).entity.func_110143_aJ()).result();
            }
            if (this.priorityHighestHealth < this.priorityLowestHealth && this.priorityHighestHealth < this.priorityClosest) {
                return ComparisonChain.start().compare(((EntityEntrySortable)o2).entity.func_110143_aJ(), ((EntityEntrySortable)o1).entity.func_110143_aJ()).compare(((EntityEntrySortable)o1).distance, ((EntityEntrySortable)o2).distance).result();
            }
            if (this.priorityLowestHealth < this.priorityHighestHealth && this.priorityLowestHealth < this.priorityClosest) {
                return ComparisonChain.start().compare(((EntityEntrySortable)o1).entity.func_110143_aJ(), ((EntityEntrySortable)o2).entity.func_110143_aJ()).compare(((EntityEntrySortable)o1).distance, ((EntityEntrySortable)o2).distance).result();
            }
            return 0;
        });
        for (EntityEntrySortable entry : list) {
            EntityLivingBase entity = entry.entity;
            Vec3d start = new Vec3d((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.78f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
            Vec3d end = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
            RayTraceResult res = this.field_145850_b.func_147447_a(start = start.func_178787_e(end.func_178787_e(start.func_186678_a(-1.0)).func_72432_b()), end, false, true, true);
            if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) continue;
            return entity;
        }
        return null;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.initialisedMulti) {
            this.initialisedMulti = this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
        }
        if (!this.field_145850_b.field_72995_K) {
            Entity toTarget;
            if (this.storage.getEnergyStoredGC() > 1000.0f && !this.getDisabled(0) && !RedstoneUtil.isBlockReceivingRedstone((World)this.field_145850_b, (BlockPos)this.func_174877_v())) {
                if (this.chargeLevel < 60) {
                    ++this.chargeLevel;
                }
            } else {
                this.chargeLevel = 0;
            }
            if (this.ticks % 20 == 0) {
                if (this.storage.getEnergyStoredGC() > 1000.0f && !this.getDisabled(0) && !RedstoneUtil.isBlockReceivingRedstone((World)this.field_145850_b, (BlockPos)this.func_174877_v())) {
                    for (Entity e : this.field_145850_b.field_72996_f) {
                        if (!(e instanceof EntityLivingBase) && !(e instanceof ILaserTrackableFast)) continue;
                        this.trackEntity(e);
                    }
                } else {
                    this.tracked.clear();
                }
                toTarget = this.updateTarget();
                if (toTarget != null && this.chargeLevel > 0) {
                    this.active = true;
                    this.targettedEntity = toTarget.func_145782_y();
                } else {
                    this.active = false;
                    this.targettedEntity = -1;
                }
            }
            if (this.chargeLevel >= 60 && this.targettedEntity != -1) {
                toTarget = this.field_145850_b.func_73045_a(this.targettedEntity);
                if (toTarget != null) {
                    if (toTarget instanceof EntityLivingBase) {
                        EntityLivingBase entityLiving = (EntityLivingBase)toTarget;
                        entityLiving.func_70097_a((DamageSource)DamageSourceGC.laserTurret, 1.5f);
                    } else if (toTarget instanceof EntityMeteor) {
                        toTarget.func_70106_y();
                    }
                    this.field_145850_b.func_184133_a(null, this.func_174877_v().func_177984_a(), GCSounds.laserShoot, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.storage.setEnergyStored(this.storage.getEnergyStoredGC() - 1000.0f);
                    this.chargeLevel = 0;
                }
            } else if (this.chargeLevel == 22) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v().func_177984_a(), GCSounds.laserCharge, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            if (this.chargeLevel > 0) {
                ++this.chargeLevel;
            }
            if (this.chargeLevel < 5) {
                this.timeSinceShot = 0;
            }
            ++this.timeSinceShot;
            if (this.active && this.targettedEntity != -1) {
                Entity entity = this.field_145850_b.func_73045_a(this.targettedEntity);
                if (entity != null && !entity.field_70128_L) {
                    Vector3 vec = new Vector3(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
                    vec.translate(new Vector3((double)(-((float)this.field_174879_c.func_177958_n() + 0.5f)), (double)(-((float)this.field_174879_c.func_177956_o() + 1.78f)), (double)(-((float)this.field_174879_c.func_177952_p() + 0.5f)))).normalize();
                    this.targetPitch = (float)(Math.asin(vec.y) * 57.29577951308232);
                    this.targetYaw = (float)(Math.atan2(vec.x, vec.z) * 57.29577951308232) + 90.0f;
                    while (this.targetYaw > 360.0f) {
                        this.targetYaw -= 360.0f;
                    }
                    while (this.targetYaw < 0.0f) {
                        this.targetYaw += 360.0f;
                    }
                    if (this.targetPitch > 90.0f) {
                        this.targetPitch = 90.0f;
                    } else if (this.targetPitch < -60.0f) {
                        this.targetPitch = -60.0f;
                    }
                }
            } else {
                this.targetPitch = -45.0f;
            }
            float diffY = this.targetYaw - this.yaw;
            this.yaw = this.targetYaw > 270.0f && this.yaw < 90.0f ? (this.yaw += (this.targetYaw - (this.yaw + 360.0f)) / 3.0f) : (this.targetYaw < 90.0f && this.yaw > 270.0f ? (this.yaw += (this.targetYaw + 360.0f - this.yaw) / 3.0f) : (this.yaw += diffY / 10.0f));
            float diffP = this.targetPitch - this.pitch;
            this.pitch += diffP / 3.0f;
            while (this.yaw > 360.0f) {
                this.yaw -= 360.0f;
            }
            while (this.yaw < 0.0f) {
                this.yaw += 360.0f;
            }
            if (this.pitch > 90.0f) {
                this.pitch = 90.0f;
            } else if (this.pitch < -60.0f) {
                this.pitch = -60.0f;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readMachineSidesFromNBT(nbt);
        NBTTagList playersTag = nbt.func_150295_c("PlayerList", 10);
        for (int i = 0; i < playersTag.func_74745_c(); ++i) {
            NBTTagCompound tagAt = playersTag.func_150305_b(i);
            this.players.add(tagAt.func_74779_i("PlayerName"));
        }
        NBTTagList entitiesTag = nbt.func_150295_c("EntitiesList", 10);
        for (int i = 0; i < entitiesTag.func_74745_c(); ++i) {
            NBTTagCompound tagAt = entitiesTag.func_150305_b(i);
            this.entities.add(new ResourceLocation(tagAt.func_74779_i("EntityRes")));
        }
        this.active = nbt.func_74767_n("active");
        this.targettedEntity = nbt.func_74762_e("targettedEntity");
        this.chargeLevel = nbt.func_74762_e("chargeLevel");
        this.blacklistMode = nbt.func_74767_n("blacklistMode");
        this.targetMeteors = nbt.func_74767_n("targetMeteors");
        this.alwaysIgnoreSpaceRace = nbt.func_74767_n("alwaysIgnoreSpaceRace");
        this.priorityClosest = nbt.func_74762_e("priorityClosest");
        this.priorityLowestHealth = nbt.func_74762_e("priorityLowestHealth");
        this.priorityHighestHealth = nbt.func_74762_e("priorityHighestHealth");
        this.ownerName = nbt.func_74764_b("ownerName") ? nbt.func_74779_i("ownerName") : null;
        this.ownerUUID = nbt.func_186857_a("ownerUUID");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.addMachineSidesToNBT(nbt);
        NBTTagList playersTag = new NBTTagList();
        for (String player : this.players) {
            NBTTagCompound tagComp = new NBTTagCompound();
            tagComp.func_74778_a("PlayerName", player);
            playersTag.func_74742_a((NBTBase)tagComp);
        }
        nbt.func_74782_a("PlayerList", (NBTBase)playersTag);
        NBTTagList entitiesTag = new NBTTagList();
        for (ResourceLocation entity : this.entities) {
            NBTTagCompound tagComp = new NBTTagCompound();
            tagComp.func_74778_a("EntityRes", entity.toString());
            entitiesTag.func_74742_a((NBTBase)tagComp);
        }
        nbt.func_74782_a("EntitiesList", (NBTBase)entitiesTag);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("targettedEntity", this.targettedEntity);
        nbt.func_74768_a("chargeLevel", this.chargeLevel);
        nbt.func_74757_a("blacklistMode", this.blacklistMode);
        nbt.func_74757_a("targetMeteors", this.targetMeteors);
        nbt.func_74757_a("alwaysIgnoreSpaceRace", this.alwaysIgnoreSpaceRace);
        nbt.func_74768_a("priorityClosest", this.priorityClosest);
        nbt.func_74768_a("priorityLowestHealth", this.priorityLowestHealth);
        nbt.func_74768_a("priorityHighestHealth", this.priorityHighestHealth);
        if (this.ownerName != null) {
            nbt.func_74778_a("ownerName", this.ownerName);
        }
        nbt.func_186854_a("ownerUUID", this.ownerUUID);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockLaserTurret) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockLaserTurret.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    public void setOwnerUUID(UUID uniqueID) {
        EntityPlayer player;
        this.ownerUUID = uniqueID;
        if (uniqueID != null && (player = this.field_145850_b.func_152378_a(uniqueID)) != null) {
            this.ownerName = player.func_70005_c_();
        }
        for (SpaceRace race : SpaceRaceManager.getSpaceRaces()) {
            if (this.ownerName == null || !race.getPlayerNames().contains(this.ownerName)) continue;
            this.setOwnerSpaceRace(race);
        }
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)GalacticraftPlanets.instance, 6, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    public void onCreate(World world, BlockPos placedPosition) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, positions, placedPosition, this.getMultiType());
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            BlockMulti.EnumBlockMultiType type;
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GCBlocks.fakeBlock || (type = (BlockMulti.EnumBlockMultiType)stateAt.func_177229_b((IProperty)BlockMulti.MULTI_TYPE)) != BlockMulti.EnumBlockMultiType.LASER_TURRET) continue;
            if (this.field_145850_b.field_72995_K) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, VenusBlocks.laserTurret.func_176223_P());
            }
            this.field_145850_b.func_175698_g(pos);
        }
        this.field_145850_b.func_175655_b(this.func_174877_v(), true);
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        int y = placedPosition.func_177956_o() + 1;
        if (y > buildHeight) {
            return;
        }
        positions.add(new BlockPos(placedPosition.func_177958_n(), y, placedPosition.func_177952_p()));
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.LASER_TURRET;
    }

    protected boolean initialiseMultiTiles(BlockPos pos, World world) {
        if (world.field_72995_K) {
            this.onCreate(world, pos);
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(pos, positions);
        boolean result = true;
        for (BlockPos vecToAdd : positions) {
            TileEntity tile = world.func_175625_s(vecToAdd);
            if (tile instanceof TileEntityMulti) {
                ((TileEntityMulti)tile).mainBlockPosition = pos;
                continue;
            }
            result = false;
        }
        return result;
    }

    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    public IMachineSidesProperties getConfigurationType() {
        return BlockMachineTiered.MACHINESIDES_RENDERTYPE;
    }

    private class EntityEntrySortable {
        private EntityLivingBase entity;
        private double distance;

        public EntityEntrySortable(EntityLivingBase entity, double distance) {
            this.entity = entity;
            this.distance = distance;
        }

        public EntityLivingBase getEntity() {
            return this.entity;
        }

        public void setEntity(EntityLivingBase entity) {
            this.entity = entity;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }
    }
}

