/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus;

import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.items.ItemBucketGC;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.GCPlanetDimensions;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.venus.ConfigManagerVenus;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockSulphuricAcid;
import micdoodle8.mods.galacticraft.planets.venus.dimension.TeleportTypeVenus;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityEntryPodVenus;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityWebShot;
import micdoodle8.mods.galacticraft.planets.venus.event.EventHandlerVenus;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerCrashedProbe;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerGeothermal;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerLaserTurret;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerSolarArrayController;
import micdoodle8.mods.galacticraft.planets.venus.network.PacketSimpleVenus;
import micdoodle8.mods.galacticraft.planets.venus.recipe.RecipeManagerVenus;
import micdoodle8.mods.galacticraft.planets.venus.tick.VenusTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityCrashedProbe;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityDungeonSpawnerVenus;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityGeothermalGenerator;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityLaserTurret;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayModule;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySpout;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityTreasureChestVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.BiomeVenus;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class VenusModule
implements IPlanetsModule {
    public static Planet planetVenus;
    public static Fluid sulphuricAcid;
    public static Fluid sulphuricAcidGC;
    public static Material acidMaterial;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        planetVenus = (Planet)new Planet("venus").setParentSolarSystem(GalacticraftCore.solarSystemSol).setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.0f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f)).setRelativeOrbitTime(0.6152793f);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerVenus());
        if (!FluidRegistry.isFluidRegistered((String)"sulphuricacid")) {
            ResourceLocation stillIcon = new ResourceLocation("galacticraftplanets:blocks/fluids/sulphuric_acid_still");
            ResourceLocation flowingIcon = new ResourceLocation("galacticraftplanets:blocks/fluids/sulphuric_acid_flow");
            sulphuricAcidGC = new Fluid("sulphuricacid", stillIcon, flowingIcon).setDensity(6229).setViscosity(1400);
            FluidRegistry.registerFluid((Fluid)sulphuricAcidGC);
        } else {
            GCLog.info((String)"Galacticraft sulphuric acid is not default, issues may occur.");
        }
        sulphuricAcid = FluidRegistry.getFluid((String)"sulphuricacid");
        if (sulphuricAcid.getBlock() == null) {
            VenusBlocks.sulphuricAcid = new BlockSulphuricAcid("sulphuric_acid");
            ((BlockSulphuricAcid)VenusBlocks.sulphuricAcid).setQuantaPerBlock(5);
            VenusBlocks.registerBlock(VenusBlocks.sulphuricAcid, ItemBlockDesc.class);
            sulphuricAcid.setBlock(VenusBlocks.sulphuricAcid);
        } else {
            VenusBlocks.sulphuricAcid = sulphuricAcid.getBlock();
        }
        if (VenusBlocks.sulphuricAcid != null) {
            FluidRegistry.addBucketForFluid((Fluid)sulphuricAcid);
            VenusItems.bucketSulphuricAcid = new ItemBucketGC(VenusBlocks.sulphuricAcid, sulphuricAcid).func_77655_b("bucket_sulphuric_acid");
            VenusItems.registerItem(VenusItems.bucketSulphuricAcid);
            EventHandlerGC.bucketList.put(VenusBlocks.sulphuricAcid, VenusItems.bucketSulphuricAcid);
        }
        VenusBlocks.initBlocks();
        VenusItems.initItems();
        planetVenus.setBiomeInfo(new Biome[]{BiomeVenus.venusFlat, BiomeVenus.venusMountain, BiomeVenus.venusValley});
    }

    @Override
    public void init(FMLInitializationEvent event) {
        VenusBlocks.oreDictRegistration();
        this.registerMicroBlocks();
        GalacticraftCore.packetPipeline.addDiscriminator(8, PacketSimpleVenus.class);
        this.registerTileEntities();
        this.registerCreatures();
        this.registerOtherEntities();
        planetVenus.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/venus.png"));
        planetVenus.setDimensionInfo(ConfigManagerVenus.dimensionIDVenus, WorldProviderVenus.class).setTierRequired(3);
        planetVenus.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), true, true, 5.0f, 0.3f, 54.0f));
        planetVenus.atmosphereComponent(EnumAtmosphericGas.CO2).atmosphereComponent(EnumAtmosphericGas.NITROGEN);
        planetVenus.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
        planetVenus.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
        planetVenus.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
        planetVenus.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
        planetVenus.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        planetVenus.addChecklistKeys(new String[]{"equip_oxygen_suit", "equip_shield_controller", "thermal_padding_t2"});
        GalaxyRegistry.registerPlanet((Planet)planetVenus);
        GalacticraftRegistry.registerTeleportType(WorldProviderVenus.class, (ITeleportType)new TeleportTypeVenus());
        GalacticraftRegistry.registerRocketGui(WorldProviderVenus.class, (ResourceLocation)new ResourceLocation("galacticraftplanets", "textures/gui/venus_rocket_gui.png"));
        GalacticraftRegistry.addDungeonLoot((int)3, (ItemStack)new ItemStack(VenusItems.volcanicPickaxe, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)3, (ItemStack)new ItemStack(VenusItems.basicItem, 1, 0));
        GalacticraftRegistry.registerGear((int)16, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER, (ItemStack)new ItemStack(VenusItems.basicItem, 1, 0));
        GalacticraftRegistry.registerGear((int)10, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_HELMET, (ItemStack)new ItemStack(VenusItems.thermalPaddingTier2, 1, 0));
        GalacticraftRegistry.registerGear((int)11, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_CHESTPLATE, (ItemStack)new ItemStack(VenusItems.thermalPaddingTier2, 1, 1));
        GalacticraftRegistry.registerGear((int)12, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_LEGGINGS, (ItemStack)new ItemStack(VenusItems.thermalPaddingTier2, 1, 2));
        GalacticraftRegistry.registerGear((int)13, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_BOOTS, (ItemStack)new ItemStack(VenusItems.thermalPaddingTier2, 1, 3));
        GalacticraftCore.proxy.registerFluidTexture(sulphuricAcid, new ResourceLocation("galacticraftplanets", "textures/misc/underacid.png"));
        MinecraftForge.EVENT_BUS.register((Object)new VenusTickHandlerServer());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        RecipeManagerVenus.loadCompatibilityRecipes();
        GCPlanetDimensions.VENUS = WorldUtil.getDimensionTypeById((int)ConfigManagerVenus.dimensionIDVenus);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Override
    public void serverInit(FMLServerStartedEvent event) {
    }

    private void registerMicroBlocks() {
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntitySpout.class, (String)"GC Venus Spout");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerVenus.class, (String)"GC Venus Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityTreasureChestVenus.class, (String)"GC Tier 3 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityGeothermalGenerator.class, (String)"GC Geothermal Generator");
        GameRegistry.registerTileEntity(TileEntityCrashedProbe.class, (String)"GC Crashed Probe");
        GameRegistry.registerTileEntity(TileEntitySolarArrayModule.class, (String)"GC Solar Array Module");
        GameRegistry.registerTileEntity(TileEntitySolarArrayController.class, (String)"GC Solar Array Controller");
        GameRegistry.registerTileEntity(TileEntityLaserTurret.class, (String)"GC Laser Turret");
    }

    public void registerCreatures() {
        this.registerGalacticraftCreature(EntityJuicer.class, "juicer", ColorUtil.to32BitColor((int)180, (int)180, (int)50, (int)0), ColorUtil.to32BitColor((int)255, (int)0, (int)2, (int)0));
        this.registerGalacticraftCreature(EntitySpiderQueen.class, "spider_queen", ColorUtil.to32BitColor((int)180, (int)180, (int)50, (int)0), ColorUtil.to32BitColor((int)255, (int)0, (int)2, (int)0));
    }

    public void registerOtherEntities() {
        VenusModule.registerGalacticraftNonMobEntity(EntityEntryPodVenus.class, "entry_pod_venus", 150, 1, true);
        VenusModule.registerGalacticraftNonMobEntity(EntityWebShot.class, "web_shot", 150, 1, true);
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(6);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        if (ID == 6) {
            if (tile instanceof TileEntityGeothermalGenerator) {
                return new ContainerGeothermal(player.field_71071_by, (TileEntityGeothermalGenerator)tile);
            }
            if (tile instanceof TileEntityCrashedProbe) {
                return new ContainerCrashedProbe(player.field_71071_by, (TileEntityCrashedProbe)tile);
            }
            if (tile instanceof TileEntitySolarArrayController) {
                return new ContainerSolarArrayController(player.field_71071_by, (TileEntitySolarArrayController)tile);
            }
            if (tile instanceof TileEntityLaserTurret) {
                return new ContainerLaserTurret(player.field_71071_by, (TileEntityLaserTurret)tile);
            }
        }
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigManagerVenus.config;
    }

    @Override
    public void syncConfig() {
        ConfigManagerVenus.syncConfig(false, false);
    }

    public void registerGalacticraftCreature(Class<? extends Entity> clazz, String name, int back, int fore) {
        VenusModule.registerGalacticraftNonMobEntity(clazz, name, 80, 3, true);
        int nextEggID = GCCoreUtil.getNextValidID();
        if (nextEggID < 65536) {
            ResourceLocation resourcelocation = new ResourceLocation("galacticraftplanets", name);
            EntityList.field_75627_a.put(resourcelocation, new EntityList.EntityEggInfo(resourcelocation, back, fore));
        }
    }

    public static void registerGalacticraftNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        ResourceLocation registryName = new ResourceLocation("galacticraftplanets", var1);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, var0, (String)var1, (int)GCCoreUtil.nextInternalID(), (Object)GalacticraftPlanets.instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    static {
        acidMaterial = new MaterialLiquid(MapColor.field_151653_I);
    }
}

