/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class WorldUtils {
    private WorldUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getWorldName(World world) {
        String result = "Unknown";
        if (world.field_73011_w != null) {
            result = world.field_73011_w.func_186058_p().func_186065_b();
        }
        return result;
    }

    public static int getLoadedChunks(WorldServer world) {
        return world.func_72863_F() != null ? world.func_72863_F().func_73152_e() : -1;
    }

    public static int getDimId(WorldServer world) {
        return world.field_73011_w != null ? world.field_73011_w.getDimension() : 0;
    }

    public static boolean areSameChunk(BlockPos first, BlockPos second) {
        return new ChunkPos(first).equals((Object)new ChunkPos(second));
    }

    @Deprecated
    public static boolean areSameChunk(World world, BlockPos first, BlockPos second) {
        return WorldUtils.areSameChunk(first, second);
    }

    public static boolean isDimension(World world, int id) {
        return WorldUtils.getDimensionId(world) == id;
    }

    public static boolean isDimension(World world, DimensionType type) {
        return WorldUtils.getDimensionType(world) == type;
    }

    public static int getDimensionId(World world) {
        return WorldUtils.getDimensionType(world).func_186068_a();
    }

    public static DimensionType getDimensionType(World world) {
        return world.field_73011_w.func_186058_p();
    }

    public static void setBiomes(World world, BlockPos pos, Biome biome) {
        try {
            Chunk chunk = world.func_175726_f(pos);
            byte[] biomes = chunk.func_76605_m();
            Arrays.fill(biomes, (byte)Biome.func_185362_a((Biome)biome));
            chunk.func_76630_e();
            WorldUtils.updateNearbyChunks(world, chunk, true, true);
        }
        catch (Exception e) {
            Constants.LOG.warn(e, "Unable to set biome for Pos: {}, Biome: {}", pos.toString(), biome.getRegistryName());
        }
    }

    public static void markChunkForUpdate(World world, Chunk chunk, boolean render) {
        chunk.func_76630_e();
        if (render) {
            BlockPos initial = chunk.func_76632_l().func_180331_a(1, 1, 1);
            world.func_175704_b(initial, initial);
        }
    }

    public static void updateNearbyChunks(World world, Chunk chunk, boolean includeSelf, boolean render) {
        for (Chunk other : WorldUtils.getNearbyChunks(world, chunk)) {
            if (other == chunk && !includeSelf) continue;
            WorldUtils.markChunkForUpdate(world, other, render);
        }
    }

    public static List<Chunk> getNearbyChunks(World world, Chunk chunk) {
        return WorldUtils.getNearbyChunks(world, chunk.func_76632_l());
    }

    public static List<Chunk> getNearbyChunks(World world, ChunkPos chunk) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int offX = -1; offX < 2; ++offX) {
            for (int offY = -1; offY < 2; ++offY) {
                chunks.add(world.func_72964_e(chunk.field_77276_a + offX, chunk.field_77275_b + offY));
            }
        }
        return chunks;
    }

    public static BlockPos getRandomChunkPosition(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        int posX = x * 16 + world.field_73012_v.nextInt(16);
        int posZ = z * 16 + world.field_73012_v.nextInt(16);
        int height = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(posX, 0, posZ)) + 1), (int)16);
        int posY = world.field_73012_v.nextInt(height > 0 ? height : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(posX, posY, posZ);
    }

    public static WorldType getWorldType(WorldProvider provider) {
        return provider.field_76577_b;
    }

    public static void setWorldType(WorldProvider provider, WorldType type) {
        provider.field_76577_b = type;
    }

    public static String getWorldSettings(WorldProvider provider) {
        return provider.field_82913_c;
    }

    public static void setWorldSettings(WorldProvider provider, String settings) {
        provider.field_82913_c = settings;
    }

    public static void attemptChunkSpawn(WorldServer world, BlockPos pos, EnumCreatureType mobType, @Nullable Consumer<EntityLiving> spawnHook) {
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos blockpos = WorldUtils.getRandomChunkPosition((World)world, chunkPos.field_77276_a, chunkPos.field_77275_b);
        int randX = blockpos.func_177958_n();
        int randY = blockpos.func_177956_o();
        int randZ = blockpos.func_177952_p();
        if (!world.func_180495_p(blockpos).func_185915_l()) {
            int offsetX = randX + MathsUtils.nextIntInclusive(-6, 6);
            int spawnY = randY + MathsUtils.nextIntInclusive(-1, 1);
            int offsetY = randZ + MathsUtils.nextIntInclusive(-6, 6);
            BlockPos currentPos = new BlockPos(offsetX, spawnY, offsetY);
            float spawnX = (float)offsetX + 0.5f;
            float spawnZ = (float)offsetY + 0.5f;
            Biome.SpawnListEntry spawnListEntry = world.func_175734_a(mobType, currentPos);
            if (spawnListEntry == null) {
                return;
            }
            if (world.func_175732_a(mobType, spawnListEntry, currentPos) && WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)spawnListEntry.field_76300_b), (World)world, (BlockPos)currentPos)) {
                int amountToSpawn = MathsUtils.nextIntInclusive(spawnListEntry.field_76301_c, spawnListEntry.field_76299_d);
                for (int attempt = 0; attempt < amountToSpawn; ++attempt) {
                    EntityLiving spawnedMob;
                    try {
                        spawnedMob = spawnListEntry.newInstance((World)world);
                    }
                    catch (Exception exception) {
                        Constants.LOG.catching(exception);
                        return;
                    }
                    if (spawnedMob == null) continue;
                    spawnedMob.func_70012_b((double)spawnX, (double)spawnY, (double)spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)spawnedMob, (World)world, (float)spawnX, (float)spawnY, (float)spawnZ, (boolean)false);
                    if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !spawnedMob.func_70601_bi() || !spawnedMob.func_70058_J())) continue;
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)spawnedMob, (World)world, (float)spawnX, (float)spawnY, (float)spawnZ)) {
                        spawnedMob.func_180482_a(world.func_175649_E(new BlockPos((Entity)spawnedMob)), null);
                    }
                    if (spawnedMob.func_70058_J()) {
                        world.func_72838_d((Entity)spawnedMob);
                        if (spawnHook == null) continue;
                        spawnHook.accept(spawnedMob);
                        continue;
                    }
                    spawnedMob.func_70106_y();
                }
            }
        }
    }

    public static boolean isHorizontal(EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }
}

