/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.recipe;

import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.IRecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.RecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.reference.EnumMortarType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class RegistryRecipeMortar {
    private EnumMap<EnumMortarType, List<RecipeMortar>> recipeMap = new EnumMap(EnumMortarType.class);

    public List<IRecipeMortar> getRecipes(EnumMortarType type, List<IRecipeMortar> result) {
        List<RecipeMortar> recipes = this.recipeMap.get(type);
        if (recipes != null) {
            result.addAll(recipes);
        }
        return result;
    }

    @Nonnull
    public RecipeMortar addRecipe(EnumMortarType type, ItemStack output, int duration, ItemStack secondaryOutput, float secondaryOutputChance, Ingredient[] inputs) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        Collections.addAll(inputList, inputs);
        RecipeMortar recipe = new RecipeMortar(output, duration, secondaryOutput, secondaryOutputChance, inputList);
        List list = this.recipeMap.computeIfAbsent(type, k -> new ArrayList());
        list.add(recipe);
        return recipe;
    }

    @Nullable
    public RecipeMortar findRecipe(EnumMortarType type, ItemStack[] inputs) {
        List<RecipeMortar> list = this.recipeMap.get(type);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (RecipeMortar recipe : list) {
            if (!recipe.matches(inputs)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matchesPartial(EnumMortarType type, ItemStack[] inputs) {
        List<RecipeMortar> list = this.recipeMap.get(type);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (RecipeMortar recipe : list) {
            if (!recipe.matchesPartial(inputs)) continue;
            return true;
        }
        return false;
    }
}

