/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.recipe;

import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.IRecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class RecipeMortar
implements IRecipeMortar {
    private ItemStack output;
    private ItemStack secondaryOutput;
    private float secondaryOutputChance;
    private int duration;
    private List<Ingredient> inputs;

    public RecipeMortar(ItemStack output, int duration, ItemStack secondaryOutput, float secondaryOutputChance, List<Ingredient> inputs) {
        this.duration = duration;
        this.output = output;
        this.secondaryOutput = secondaryOutput == null ? ItemStack.field_190927_a : secondaryOutput;
        this.secondaryOutputChance = secondaryOutputChance;
        this.inputs = new ArrayList<Ingredient>(inputs);
    }

    public List<Ingredient> getIngredients() {
        return this.inputs;
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput.func_77946_l();
    }

    @Override
    public float getSecondaryOutputChance() {
        return this.secondaryOutputChance;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public boolean matches(ItemStack[] inputs) {
        int i;
        boolean[] matchedInputs = new boolean[inputs.length];
        int[] availableCounts = new int[inputs.length];
        for (i = 0; i < inputs.length; ++i) {
            availableCounts[i] = inputs[i].func_190916_E();
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            Ingredient ingredient = this.inputs.get(i);
            ItemStack[] matchingStacks = ingredient.func_193365_a();
            if (matchingStacks.length == 0) {
                return false;
            }
            int requiredCount = matchingStacks[0].func_190916_E();
            for (int j = 0; j < inputs.length; ++j) {
                boolean ingredientMatches = Utils.ingredientApplyWithNBT(ingredient, inputs[j]);
                if (ingredientMatches) {
                    matchedInputs[j] = true;
                }
                if (availableCounts[j] <= 0 || !ingredientMatches) continue;
                if (requiredCount == availableCounts[j]) {
                    requiredCount -= availableCounts[j];
                    availableCounts[j] = 0;
                    continue;
                }
                if (requiredCount < availableCounts[j]) {
                    int availableCount = availableCounts[j];
                    int n = j;
                    availableCounts[n] = availableCounts[n] - requiredCount;
                    requiredCount -= availableCount;
                    continue;
                }
                requiredCount -= availableCounts[j];
                availableCounts[j] = 0;
            }
            if (requiredCount <= 0) continue;
            return false;
        }
        for (boolean matchedInput : matchedInputs) {
            if (matchedInput) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPartial(ItemStack[] inputs) {
        boolean[] matchedInputs = new boolean[inputs.length];
        for (Ingredient ingredient : this.inputs) {
            ItemStack[] matchingStacks = ingredient.func_193365_a();
            if (matchingStacks.length == 0) {
                return false;
            }
            for (int j = 0; j < inputs.length; ++j) {
                if (!inputs[j].func_190926_b() && (matchedInputs[j] || !Utils.ingredientApplyWithNBT(ingredient, inputs[j]))) continue;
                matchedInputs[j] = true;
            }
        }
        for (Object matchedInput : (Object)matchedInputs) {
            if (matchedInput != false) continue;
            return false;
        }
        return true;
    }
}

