/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.item;

import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleConfig;
import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleMortar;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemBlockMortar
extends ItemMultiTexture {
    public ItemBlockMortar(Block block, ItemMultiTexture.Mapper mapper) {
        super(block, block, mapper);
        this.func_77625_d(1);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            throw new RuntimeException("Block missing registry name: " + block.getClass().getName());
        }
        this.setRegistryName(registryName);
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int maxDurability = ModuleMortar.Blocks.MORTAR.getMaxDurability(stack);
        if (maxDurability > 0) {
            NBTTagCompound stackCompound = stack.func_77978_p();
            if (stackCompound != null && stackCompound.func_74764_b("BlockEntityTag")) {
                NBTTagCompound compound = stackCompound.func_74775_l("BlockEntityTag");
                int durability = maxDurability - compound.func_74762_e("durability");
                tooltip.add(I18n.func_135052_a((String)"tooltip.advancedmortars.durability", (Object[])new Object[]{durability + "/" + maxDurability}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.advancedmortars.durability", (Object[])new Object[]{maxDurability + "/" + maxDurability}));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.advancedmortars.durability", (Object[])new Object[]{TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.advancedmortars.durability.unbreakable", (Object[])new Object[0]) + TextFormatting.GRAY}));
        }
        if (GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.advancedmortars.extended.pickup", (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY, TextFormatting.AQUA, TextFormatting.GRAY}));
            tooltip.add(I18n.func_135052_a((String)"tooltip.advancedmortars.extended.retrieve", (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY, TextFormatting.AQUA, TextFormatting.GRAY}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.advancedmortars.extended", (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int maxDurability = ModuleMortar.Blocks.MORTAR.getMaxDurability(stack);
        if (maxDurability <= 0) {
            return false;
        }
        return ModuleConfig.CLIENT.DISPLAY_MORTAR_DURABILITY && this.getDurabilityForDisplay(stack) < 0.9999999999;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int maxDurability = ModuleMortar.Blocks.MORTAR.getMaxDurability(stack);
        if (maxDurability <= 0) {
            return 0.0;
        }
        NBTTagCompound stackCompound = stack.func_77978_p();
        int durability = 0;
        if (stackCompound != null && stackCompound.func_74764_b("BlockEntityTag")) {
            NBTTagCompound compound = stackCompound.func_74775_l("BlockEntityTag");
            durability = maxDurability - compound.func_74762_e("durability");
        }
        return 1.0 - (double)durability / (double)maxDurability;
    }
}

