/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.integration.jei;

import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.api.MortarAPI;
import com.codetaylor.mc.advancedmortars.modules.mortar.integration.jei.JEICategoryMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.integration.jei.JEIRecipeWrapperMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.IRecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.RecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.reference.EnumMortarType;
import java.util.ArrayList;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.gui.elements.DrawableResource;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JEIPlugin
public class PluginJEI
implements IModPlugin {
    private static final String TEXTURE_BACKGROUND = "textures/gui/jei.png";
    private IJeiHelpers jeiHelpers;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.jeiHelpers = registry.getJeiHelpers();
        for (EnumMortarType type : EnumMortarType.values()) {
            registry.addRecipeCategories(new IRecipeCategory[]{this.createCategory(type)});
        }
    }

    public void register(IModRegistry registry) {
        for (EnumMortarType type : EnumMortarType.values()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleMortar.Blocks.MORTAR, 1, type.getMeta()), new String[]{this.createUID(type)});
        }
        for (EnumMortarType type : EnumMortarType.values()) {
            registry.handleRecipes(RecipeMortar.class, JEIRecipeWrapperMortar::new, this.createUID(type));
        }
        for (EnumMortarType type : EnumMortarType.values()) {
            ArrayList<IRecipeMortar> recipeList = new ArrayList<IRecipeMortar>();
            MortarAPI.RECIPE_REGISTRY.getRecipes(type, recipeList);
            registry.addRecipes(recipeList, this.createUID(type));
        }
    }

    private JEICategoryMortar createCategory(EnumMortarType type) {
        return new JEICategoryMortar(this.createUID(type), this.createTitleTranslateKey(type), this.createBackground());
    }

    private IDrawable createBackground() {
        ResourceLocation resourceLocation = new ResourceLocation("advancedmortars", TEXTURE_BACKGROUND);
        return new DrawableResource(resourceLocation, 0, 0, 124, 62, 8, 0, 8, 0, 116, 54){

            public void draw(Minecraft minecraft) {
                GlStateManager.func_179147_l();
                super.draw(minecraft);
                GlStateManager.func_179084_k();
            }
        };
    }

    private String createTitleTranslateKey(EnumMortarType type) {
        return "text.advancedmortars.jei.category.mortar." + type.func_176610_l();
    }

    private String createUID(EnumMortarType type) {
        return "advancedmortars_" + type.func_176610_l();
    }
}

