/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.integration.crafttweaker.mtlib;

import com.codetaylor.mc.advancedmortars.modules.mortar.integration.crafttweaker.mtlib.LogHelper;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.item.MCItemStack;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class InputHelper {
    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            LogHelper.logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static <T> T[][] getMultiDimensionalArray(Class<T> clazz, T[] array, int height, int width) {
        Object[][] multiDim = (Object[][])Array.newInstance(clazz, height, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                multiDim[y][x] = array[x + y * width];
            }
        }
        return multiDim;
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = InputHelper.toStack(iStack[i]);
        }
        return output;
    }

    public static IItemStack toIItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new MCItemStack(stack);
    }

    public static List<ItemStack> getMatchingStacks(IIngredient ingredient, List<ItemStack> result) {
        if (ingredient == null) {
            return result;
        }
        if (ingredient instanceof IOreDictEntry) {
            NonNullList ores = OreDictionary.getOres((String)((IOreDictEntry)ingredient).getName());
            InputHelper.getMatchingStacks((List<ItemStack>)ores, ingredient.getAmount(), result);
        } else if (ingredient instanceof IItemStack) {
            ItemStack itemStack = InputHelper.toStack((IItemStack)ingredient);
            itemStack.func_190920_e(ingredient.getAmount());
            result.add(itemStack);
        } else {
            List items = ingredient.getItems();
            for (IItemStack item : items) {
                ItemStack itemStack = InputHelper.toStack(item);
                InputHelper.getMatchingStacks(Collections.singletonList(itemStack), ingredient.getAmount(), result);
            }
        }
        return result;
    }

    public static List<ItemStack> getMatchingStacks(List<ItemStack> itemStackList, int amount, List<ItemStack> result) {
        NonNullList internalList = NonNullList.func_191196_a();
        for (ItemStack itemStack : itemStackList) {
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, internalList);
                continue;
            }
            internalList.add((Object)itemStack);
        }
        for (ItemStack itemStack : internalList) {
            itemStack.func_190920_e(amount);
        }
        result.addAll((Collection<ItemStack>)internalList);
        return result;
    }
}

