/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.selector;

import com.google.gson.annotations.SerializedName;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.utils.expression.BiomeExpression;
import ivorius.reccomplex.utils.expression.DimensionExpression;
import ivorius.reccomplex.world.gen.feature.selector.MixingStructureSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;

public class NaturalStructureSelector {
    public static final double STRUCTURE_MIN_CAP_DEFAULT = 20.0;
    public static SimpleLeveledRegistry<Category> CATEGORY_REGISTRY = new SimpleLeveledRegistry("natural generation category");

    public static class GenerationInfo {
        @SerializedName(value="spawnChance")
        public double spawnChance;
        public double[] spawnChances;
        @SerializedName(value="biomeMatcher")
        public BiomeExpression biomeExpression;
        @SerializedName(value="dimensionMatcher")
        public DimensionExpression dimensionExpression;

        public GenerationInfo(double[] spawnChance, BiomeExpression biomeExpression, DimensionExpression dimensionExpression) {
            this.spawnChances = spawnChance;
            this.biomeExpression = biomeExpression;
            this.dimensionExpression = dimensionExpression;
        }
    }

    public static class SimpleCategory
    implements Category {
        @SerializedName(value="generationInfos")
        public final List<GenerationInfo> generationInfos = new ArrayList<GenerationInfo>();
        @SerializedName(value="defaultSpawnChance")
        public double defaultSpawnChance;
        @SerializedName(value="defaultSpawnChances")
        public double[] defaultSpawnChances;
        @SerializedName(value="structureMinCap")
        public Double structureMinCap = null;
        @SerializedName(value="spawnDistanceMultiplier")
        public float spawnDistanceMultiplier = 0.0f;
        @SerializedName(value="spawnDistanceMultiplierCap")
        public float spawnDistanceMultiplierCap = 1.0f;
        @SerializedName(value="selectableInGUI")
        public boolean selectableInGUI = true;
        @SerializedName(value="title")
        public String title = "";
        @SerializedName(value="tooltip")
        public final List<String> tooltip = new ArrayList<String>();

        @Override
        public int structuresInBiome(Biome biome, WorldProvider worldProvider, double totalWeight, Float distanceToSpawn, Random random) {
            return (int)Arrays.stream(this.spawnChance(biome, worldProvider)).filter(chance -> random.nextDouble() < chance * this.amountMultiplier(totalWeight) * this.distanceMultiplier(distanceToSpawn) * (double)RCConfig.structureSpawnChanceModifier).count();
        }

        public double amountMultiplier(double totalWeight) {
            return Math.min(totalWeight / this.getActiveStructureMinCap(), 1.0);
        }

        public double[] spawnChance(Biome biome, WorldProvider worldProvider) {
            double[] dArray;
            if (this.defaultSpawnChances != null) {
                dArray = this.defaultSpawnChances;
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = this.defaultSpawnChance;
            }
            double[] am = dArray;
            for (GenerationInfo info : this.generationInfos) {
                double[] dArray3;
                if (!info.biomeExpression.test(biome) || !info.dimensionExpression.test(worldProvider)) continue;
                if (info.spawnChances != null) {
                    dArray3 = info.spawnChances;
                } else {
                    double[] dArray4 = new double[1];
                    dArray3 = dArray4;
                    dArray4[0] = info.spawnChance;
                }
                am = dArray3;
            }
            return am;
        }

        public double distanceMultiplier(Float distance) {
            return distance == null ? 1.0 : (this.spawnDistanceMultiplier > 1.0f ? (double)Math.min(1.0f + distance.floatValue() * this.spawnDistanceMultiplier, Math.max(this.spawnDistanceMultiplierCap, 1.0f)) : (double)Math.max(1.0f + distance.floatValue() * this.spawnDistanceMultiplier, Math.min(this.spawnDistanceMultiplierCap, 1.0f)));
        }

        public Double getActiveStructureMinCap() {
            return this.structureMinCap != null ? this.structureMinCap : 20.0;
        }

        @Override
        public boolean selectableInGUI() {
            return this.selectableInGUI;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public List<String> tooltip() {
            return this.tooltip;
        }
    }

    public static interface Category
    extends MixingStructureSelector.Category {
        public boolean selectableInGUI();

        public String title();

        public List<String> tooltip();
    }
}

