/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import gnu.trove.map.TIntFloatMap;
import gnu.trove.map.hash.TIntFloatHashMap;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableCellMulti
extends TableCellDefault {
    public static final int CELL_MIN_WIDTH = 17;
    @Nonnull
    protected final List<TableCell> cells = new ArrayList<TableCell>();
    protected TIntFloatMap cellsSize = new TIntFloatHashMap(10, 0.5f, -1, 1.0f);

    public TableCellMulti(String id, @Nonnull List<? extends TableCell> cells) {
        super(id);
        this.cells.addAll(cells);
    }

    public TableCellMulti(String id, TableCell ... cells) {
        this(id, Arrays.asList(cells));
    }

    public TableCellMulti(@Nonnull List<? extends TableCell> cells) {
        this(null, cells);
    }

    public TableCellMulti(TableCell ... cells) {
        this((String)null, cells);
    }

    public void setSize(int cell, float size) {
        this.cellsSize.put(cell, size);
    }

    public float getScalingSize(int cell) {
        return this.cellsSize.get(cell);
    }

    public int getScaledSize(int width, float total, int cell) {
        return (int)((float)width * (this.getScalingSize(cell) / total));
    }

    @Override
    public void initGui(GuiTable screen) {
        for (TableCell cell : this.cells) {
            cell.initGui(screen);
        }
    }

    @Override
    public void setBounds(Bounds bounds) {
        int i;
        float total = (float)IntStream.range(0, this.cells.size()).mapToDouble(this::getScalingSize).sum();
        int spreadableWidth = bounds.getWidth();
        for (int n = 0; n < this.cells.size(); ++n) {
            for (i = 0; i < this.cells.size(); ++i) {
                if (this.getScaledSize(spreadableWidth, total, i) >= 17) continue;
                total -= this.getScalingSize(i);
                spreadableWidth -= 17;
            }
        }
        int curPos = 0;
        for (i = 0; i < this.cells.size(); ++i) {
            boolean isLast = i == this.cells.size() - 1;
            boolean isFirst = i == 0;
            int buttonWidth = isLast ? bounds.getWidth() - curPos : Math.max(17, this.getScaledSize(spreadableWidth, total, i));
            TableCell cell = this.cells.get(i);
            cell.setBounds(Bounds.fromAxes(bounds.getMinX() + curPos + (isFirst ? 0 : 1), buttonWidth - (isLast || isFirst ? 1 : 2), bounds.getMinY(), bounds.getHeight()));
            curPos += buttonWidth;
        }
        super.setBounds(bounds);
    }

    @Override
    public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        for (TableCell cell : this.cells) {
            if (cell.isHidden()) continue;
            cell.draw(screen, mouseX, mouseY, partialTicks);
        }
        super.draw(screen, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawFloating(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        for (TableCell cell : this.cells) {
            if (cell.isHidden()) continue;
            cell.drawFloating(screen, mouseX, mouseY, partialTicks);
        }
        super.drawFloating(screen, mouseX, mouseY, partialTicks);
    }

    @Override
    public void update(GuiTable screen) {
        for (TableCell cell : this.cells) {
            cell.update(screen);
        }
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        for (TableCell cell : this.cells) {
            if (!cell.keyTyped(keyChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(int button, int x, int y) {
        for (TableCell cell : this.cells) {
            cell.mouseClicked(button, x, y);
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        for (TableCell cell : this.cells) {
            cell.buttonClicked(buttonID);
        }
    }
}

