/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Bounds {
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    public Bounds(int minX, int maxX, int minY, int maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public static Bounds fromAxes(int x, int width, int y, int height) {
        return new Bounds(x, x + width, y, y + height);
    }

    public static Bounds fromSize(int x, int y, int width, int height) {
        return new Bounds(x, x + width, y, y + height);
    }

    public static Bounds fromButton(GuiButton button) {
        return Bounds.fromAxes(button.field_146128_h, button.field_146120_f, button.field_146129_i, button.field_146121_g);
    }

    public static Bounds fromTextField(GuiTextField textField) {
        return Bounds.fromAxes(textField.field_146209_f, textField.field_146218_h, textField.field_146210_g, textField.field_146219_i);
    }

    public static void set(GuiButton button, Bounds bounds) {
        button.field_146128_h = bounds.getMinX();
        button.field_146129_i = bounds.getMinY();
        button.field_146120_f = bounds.getWidth();
        button.field_146121_g = bounds.getHeight();
    }

    public static void set(GuiTextField textField, Bounds bounds) {
        textField.field_146209_f = bounds.getMinX();
        textField.field_146210_g = bounds.getMinY();
        textField.field_146218_h = bounds.getWidth();
        textField.field_146219_i = bounds.getHeight();
        textField.func_146190_e(textField.func_146198_h());
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public int getCenterX() {
        return (this.minX + this.maxX) / 2;
    }

    public int getCenterY() {
        return (this.minY + this.maxY) / 2;
    }

    public boolean contains(int x, int y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }
}

