/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.nbt;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.nbt.TableDataSourceNBTList;
import ivorius.reccomplex.gui.nbt.TableDataSourceNBTTagCompound;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellDefault;
import ivorius.reccomplex.gui.table.cell.TableCellIntTextField;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TableCellStringDouble;
import ivorius.reccomplex.gui.table.cell.TableCellStringLong;
import ivorius.reccomplex.gui.table.cell.TableCellTitle;
import ivorius.reccomplex.json.NBTTagEndSerializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceNBT {
    private static final Object[] TYPE_LOOKUP = new Object[]{"End", 0, "Byte", 1, "Short", 2, "Int", 3, "Long", 4, "Float", 5, "Double", 6, "Bytes", 7, "String", 8, "List", 9, "Compound", 10, "Ints", 11};

    public static TableCell cell(@Nullable NBTBase nbt, @Nonnull TableDelegate delegate, @Nonnull TableNavigator navigator) {
        TableCellDefault cell = TableDataSourceNBT.rawCell(nbt, delegate, navigator);
        cell.setTooltip(Collections.singletonList(nbt != null ? (String)TYPE_LOOKUP[ArrayUtils.indexOf((Object[])TYPE_LOOKUP, (Object)nbt.func_74732_a()) - 1] : "null"));
        return cell;
    }

    @Nonnull
    public static TableCellDefault rawCell(@Nullable NBTBase nbt, @Nonnull TableDelegate delegate, @Nonnull TableNavigator navigator) {
        if (nbt == null) {
            return new TableCellTitle(null, "null");
        }
        if (nbt instanceof NBTTagEnd) {
            return new TableCellTitle(null, "-");
        }
        if (nbt instanceof NBTTagByte) {
            NBTTagByte cNBT = (NBTTagByte)nbt;
            TableCellIntTextField cell = new TableCellIntTextField(null, cNBT.func_150287_d());
            cell.addListener(value -> {
                if (value >= -128 && value <= 127) {
                    ReflectionHelper.setPrivateValue(NBTTagByte.class, (Object)cNBT, (Object)((byte)value.intValue()), (String[])new String[]{"field_74756_a", "data"});
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                } else {
                    cell.setValidityState(GuiValidityStateIndicator.State.INVALID);
                }
            });
            return cell;
        }
        if (nbt instanceof NBTTagShort) {
            NBTTagShort cNBT = (NBTTagShort)nbt;
            TableCellIntTextField cell = new TableCellIntTextField(null, cNBT.func_150287_d());
            cell.addListener(value -> {
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    ReflectionHelper.setPrivateValue(NBTTagShort.class, (Object)cNBT, (Object)((short)value.intValue()), (String[])new String[]{"field_74752_a", "data"});
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                } else {
                    cell.setValidityState(GuiValidityStateIndicator.State.INVALID);
                }
            });
            return cell;
        }
        if (nbt instanceof NBTTagInt) {
            NBTTagInt cNBT = (NBTTagInt)nbt;
            TableCellIntTextField cell = new TableCellIntTextField(null, cNBT.func_150287_d());
            cell.addListener(value -> ReflectionHelper.setPrivateValue(NBTTagInt.class, (Object)cNBT, (Object)value, (String[])new String[]{"field_74748_a", "data"}));
            return cell;
        }
        if (nbt instanceof NBTTagLong) {
            NBTTagLong cNBT = (NBTTagLong)nbt;
            TableCellStringLong cell = new TableCellStringLong(null, cNBT.func_150291_c());
            cell.addListener(value -> ReflectionHelper.setPrivateValue(NBTTagLong.class, (Object)cNBT, (Object)value, (String[])new String[]{"field_74753_a", "data"}));
            return cell;
        }
        if (nbt instanceof NBTTagFloat) {
            NBTTagFloat cNBT = (NBTTagFloat)nbt;
            TableCellStringDouble cell = new TableCellStringDouble(null, cNBT.func_150286_g());
            cell.addListener(value -> ReflectionHelper.setPrivateValue(NBTTagFloat.class, (Object)cNBT, (Object)Float.valueOf((float)value.doubleValue()), (String[])new String[]{"field_74750_a", "data"}));
            return cell;
        }
        if (nbt instanceof NBTTagDouble) {
            NBTTagDouble cNBT = (NBTTagDouble)nbt;
            TableCellStringDouble cell = new TableCellStringDouble(null, cNBT.func_150286_g());
            cell.addListener(value -> ReflectionHelper.setPrivateValue(NBTTagDouble.class, (Object)cNBT, (Object)value, (String[])new String[]{"field_74755_a", "data"}));
            return cell;
        }
        if (nbt instanceof NBTTagByteArray) {
            NBTTagByteArray cNBT = (NBTTagByteArray)nbt;
            TableCellString cell = new TableCellString(null, String.join((CharSequence)",", Arrays.stream(ArrayUtils.toObject((byte[])cNBT.func_150292_c())).map(String::valueOf)::iterator));
            cell.setShowsValidityState(true);
            cell.addListener(value -> {
                byte[] bytes = TableDataSourceNBT.parseBytes(value);
                if (bytes == null) {
                    cell.setValidityState(GuiValidityStateIndicator.State.INVALID);
                } else {
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                    ReflectionHelper.setPrivateValue(NBTTagByteArray.class, (Object)cNBT, (Object)bytes, (String[])new String[]{"field_74754_a", "data"});
                }
            });
            return cell;
        }
        if (nbt instanceof NBTTagString) {
            NBTTagString cNBT = (NBTTagString)nbt;
            TableCellString cell = new TableCellString(null, cNBT.func_150285_a_());
            cell.addListener(value -> ReflectionHelper.setPrivateValue(NBTTagString.class, (Object)cNBT, (Object)value, (String[])new String[]{"field_74751_a", "data"}));
            return cell;
        }
        if (nbt instanceof NBTTagList) {
            return TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceNBTList(delegate, navigator, (NBTTagList)nbt)).build();
        }
        if (nbt instanceof NBTTagCompound) {
            return TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceNBTTagCompound(delegate, navigator, (NBTTagCompound)nbt)).build();
        }
        if (nbt instanceof NBTTagIntArray) {
            NBTTagIntArray cNBT = (NBTTagIntArray)nbt;
            TableCellString cell = new TableCellString(null, String.join((CharSequence)",", Arrays.stream(ArrayUtils.toObject((int[])cNBT.func_150302_c())).map(String::valueOf)::iterator));
            cell.setShowsValidityState(true);
            cell.addListener(value -> {
                int[] ints = TableDataSourceNBT.parseInts(value);
                if (ints == null) {
                    cell.setValidityState(GuiValidityStateIndicator.State.INVALID);
                } else {
                    cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                    ReflectionHelper.setPrivateValue(NBTTagIntArray.class, (Object)cNBT, (Object)ints, (String[])new String[]{"field_74749_a", "intArray"});
                }
            });
            return cell;
        }
        RecurrentComplex.logger.error("Unexpected nbt type: " + nbt.getClass());
        throw new InternalError();
    }

    private static byte[] parseBytes(String string) {
        if (string.isEmpty()) {
            return new byte[0];
        }
        String[] strings = string.split(",");
        byte[] bytes = new byte[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                bytes[i] = Byte.parseByte(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return bytes;
    }

    private static int[] parseInts(String string) {
        if (string.isEmpty()) {
            return new int[0];
        }
        String[] strings = string.split(",");
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ints[i] = Integer.parseInt(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return ints;
    }

    @Nonnull
    public static TableCellButton addButton(int id, Consumer<NBTBase> consumer) {
        TableCellButton button = TableCells.add(true, (String)TYPE_LOOKUP[id * 2], (String)TYPE_LOOKUP[id * 2], null);
        button.addAction(() -> consumer.accept(TableDataSourceNBT.typeSupplier(id).get()));
        return button;
    }

    public static Supplier<NBTBase> typeSupplier(int id) {
        switch (id) {
            case 0: {
                return NBTTagEndSerializer::createNBTTagEnd;
            }
            case 1: {
                return () -> new NBTTagByte(0);
            }
            case 2: {
                return () -> new NBTTagShort(0);
            }
            case 3: {
                return () -> new NBTTagInt(0);
            }
            case 4: {
                return () -> new NBTTagLong(0L);
            }
            case 5: {
                return () -> new NBTTagFloat(0.0f);
            }
            case 6: {
                return () -> new NBTTagDouble(0.0);
            }
            case 7: {
                return () -> new NBTTagByteArray(new byte[0]);
            }
            case 8: {
                return NBTTagString::new;
            }
            case 9: {
                return NBTTagList::new;
            }
            case 10: {
                return NBTTagCompound::new;
            }
            case 11: {
                return () -> new NBTTagIntArray(new int[0]);
            }
        }
        throw new IllegalStateException();
    }

    @Nonnull
    public static TableCellButton typeButton(int id, Runnable runnable) {
        TableCellButton button = TableCells.add(true, (String)TYPE_LOOKUP[id * 2], "Set to " + (String)TYPE_LOOKUP[id * 2], null);
        button.addAction(runnable);
        return button;
    }
}

