/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.info;

import com.google.common.collect.Lists;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.expect.IvE;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.shadow.mcopts.commands.CommandSplit;
import ivorius.reccomplex.shadow.mcopts.commands.SimpleCommand;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.shadow.mcopts.translation.ServerTranslations;
import java.util.Arrays;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandDimensionDict
extends CommandSplit {
    public CommandDimensionDict() {
        super(RCConfig.commandPrefix + "dimension");
        this.add(new SimpleCommand("types", expect -> expect.then(MCE::dimension).required()){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                WorldProvider provider = ((WorldServer)parameters.get((int)0).to(MCP.dimension((MinecraftServer)server, (ICommandSender)sender)).require()).field_73011_w;
                sender.func_145747_a(RecurrentComplex.translations.format("commands.dimensiondict.get", RCTextStyle.dimension(provider.getDimension()), ServerTranslations.join(Lists.newArrayList(DimensionDictionary.getDimensionTypes(provider)).stream().map(RCTextStyle::dimensionType).toArray())));
            }
        });
        this.add(new SimpleCommand("list", expect -> expect.then(IvE::dimensionType).required()){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                String type = parameters.get(0).require();
                sender.func_145747_a(RecurrentComplex.translations.format("commands.dimensiondict.list", RCTextStyle.dimensionType(type), ServerTranslations.join(Arrays.stream(CommandDimensionDict.allDimensionsOfType(type).toArray()).mapToObj(RCTextStyle::dimension).toArray())));
            }
        });
        this.permitFor(2);
    }

    public static TIntList allDimensionsOfType(String type) {
        TIntArrayList intList = new TIntArrayList();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int d = integerArray[i];
            if (!DimensionDictionary.dimensionMatchesType(DimensionManager.getProvider((int)d), type)) continue;
            intList.add(d);
        }
        return intList;
    }
}

