/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;

public class IvFileHelper {
    public static InputStream inputStreamFromResourceLocation(ResourceLocation resourceLocation) {
        return IvFileHelper.class.getResourceAsStream("/assets/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a());
    }

    public static void setContentsOfFile(OutputStream outputStream, byte[] contents) {
        try {
            outputStream.write(contents);
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setContentsOfFile(File file, byte[] contents) {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IvFileHelper.setContentsOfFile(output, contents);
    }

    public static void setContentsOfFileAsString(File file, String contents) {
        char[] charArray = contents.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        IvFileHelper.setContentsOfFile(file, byteArray);
    }

    public static byte[] getContentsOfFile(InputStream inputStream) {
        ArrayList<Byte> array = new ArrayList<Byte>();
        try {
            int i;
            while ((i = inputStream.read()) >= 0) {
                array.add((byte)i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        byte[] byteArray = new byte[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            byteArray[i] = (Byte)array.get(i);
        }
        return byteArray;
    }

    public static byte[] getContentsOfFile(File file) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return IvFileHelper.getContentsOfFile(input);
    }

    public static String getContentsOfFileAsString(File file) {
        return IvFileHelper.getStringFromByteArray(IvFileHelper.getContentsOfFile(file));
    }

    public static byte[] getContentsOfFileInJar(String path) {
        return IvFileHelper.getContentsOfFile(IvFileHelper.class.getResourceAsStream(path));
    }

    public static String getContentsOfFileInJarAsString(String path) {
        return IvFileHelper.getStringFromByteArray(IvFileHelper.getContentsOfFileInJar(path));
    }

    public static String getStringFromByteArray(byte[] byteArray) {
        char[] charArray = new char[byteArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = (char)byteArray[i];
        }
        return String.valueOf(charArray);
    }

    public static File getValidatedFolder(File file) {
        if (!file.exists() && !file.mkdir()) {
            System.out.println("Could not create " + file.getName() + " folder");
        }
        return file.exists() ? file : null;
    }

    public static File getValidatedFolder(File parent, String child) {
        return IvFileHelper.getValidatedFolder(new File(parent, child));
    }
}

