/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.tools.GuavaCollectors;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class MazeComponents {
    public static <M extends MazeComponent<C>, C> Function<M, Stream<ShiftedMazeComponent<M, C>>> shiftAllFunction(MazePassage connection, C connector, ConnectionStrategy<C> strategy) {
        return component -> component.exits().entrySet().stream().map(entry -> {
            MazeRoom dist = ((MazePassage)((Object)((Object)((Object)entry.getKey())))).inverseDistance(connection);
            if (dist != null && strategy.connect(connection, connector, entry.getValue()) >= 0.0f) {
                return MazeComponents.shift(component, dist);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static <M extends MazeComponent<C>, C> ShiftedMazeComponent<M, C> shift(M component, MazeRoom shift) {
        ImmutableSet rooms = component.rooms().stream().map(r -> r != null ? r.add(shift) : null).collect(GuavaCollectors.immutableSet());
        ImmutableMap<MazePassage, Object> exits = component.exits().keySet().stream().collect(GuavaCollectors.toMap(c1 -> c1 != null ? c1.add(shift) : null, component.exits()::get));
        ImmutableMultimap reachability = component.reachability().keySet().stream().collect(GuavaCollectors.toMultimap(c -> c.add(shift), c -> component.reachability().get((Object)c).stream().map(c2 -> c2.add(shift))::iterator));
        return new ShiftedMazeComponent<M, Object>(component, shift, rooms, exits, reachability);
    }

    public static boolean overlap(MazeComponent<?> left, MazeComponent<?> right) {
        return Sets.intersection(left.rooms(), right.rooms()).size() > 0;
    }

    public static <C> float connectWeight(MazeComponent<C> existing, MazeComponent<C> add, ConnectionStrategy<C> strategy) {
        float total = 1.0f;
        for (Map.Entry<MazePassage, C> entry : add.exits().entrySet()) {
            float f;
            total *= strategy.connect(entry.getKey(), existing.exits().get((Object)entry.getKey().inverse()), entry.getValue());
            if (!(f < 0.0f)) continue;
            return -1.0f;
        }
        return total;
    }
}

