/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.scythe.ItemScythe;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilOreDictionary;
import com.lothrazar.cyclicmagic.util.UtilString;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class UtilScythe {
    private static NonNullList<String> blacklistAll;
    private static ScytheConfig leafConfig;
    private static ScytheConfig brushConfig;
    private static boolean weedsClassCheck;
    private static boolean leavesClassCheck;

    public static void syncConfig(Configuration config) {
        String category = "modpacks";
        weedsClassCheck = config.getBoolean("tool_harvest_weeds.class_defaults", category, true, "If true this will try an auto-detect blocks that are a weed/bush/tallgrass type by class type, which means harvesting many blocks that are not explicitly in the whitelist.  This is useful for handling vanilla and most modded blocks.  If you want more precise control you can turn this false which means ONLY the whitelists will be harvested, so you would have to add every block yourself. ");
        leavesClassCheck = config.getBoolean("tool_harvest_leaves.class_defaults", category, true, "If true this will try an auto-detect blocks that are a leaf-type by class type, which means harvesting many blocks that are not explicitly in the whitelist.  This is useful for handling vanilla and most modded blocks.  If you want more precise control you can turn this false which means ONLY the whitelists will be harvested, so you would have to add every block yourself. ");
        blacklistAll = NonNullList.func_193580_a((Object)"", (Object[])config.getStringList("ScytheBlacklist", category, new String[]{"terraqueous:pergola", "harvestcraft:*_sapling"}, "Crops & leaves that are blocked from harvesting (Brush Scythe and Tree Scythe). A star is for a wildcard "));
        UtilScythe.leafConfig.blockWhitelist = NonNullList.func_193580_a((Object)"", (Object[])config.getStringList("tool_harvest_leaves.whitelist", category, new String[]{"extratrees:leaves.decorative.0", "extratrees:leaves.decorative.1", "extratrees:leaves.decorative.2", "extratrees:leaves.decorative.3", "extratrees:leaves.decorative.4", "extratrees:leaves.decorative.5", "forestry:leaves.decorative.0", "forestry:leaves.decorative.1", "terraqueous:foliage3:5", "plants2:nether_leaves", "plants2:crystal_leaves", "plants2:leaves_0", "plants2:bush"}, "Blocks that the Tree Scythe will attempt to harvest as if they are leaves.  A star is for a wildcard "));
        UtilScythe.leafConfig.oreDictWhitelist = NonNullList.func_193580_a((Object)"", (Object[])config.getStringList("tool_harvest_leaves.whitelist_oredict", category, new String[]{"treeLeaves"}, "Ore dictionary entries that the Tree Scythe will attempt to harvest as if they are leaves.   "));
        UtilScythe.brushConfig.oreDictWhitelist = NonNullList.func_193580_a((Object)"", (Object[])config.getStringList("tool_harvest_weeds.whitelist_oredict", category, new String[]{"vine", "plant", "flowerYellow", "stickWood"}, "Ore dictionary entries that the Brush Scythe will attempt to harvest as if they are leaves.  "));
        UtilScythe.brushConfig.blockWhitelist = NonNullList.func_193580_a((Object)"", (Object[])config.getStringList("tool_harvest_weeds.whitelist", category, new String[]{"plants2:cosmetic_0", "plants2:cosmetic_1", "plants2:cosmetic_2", "plants2:cosmetic_3", "plants2:cosmetic_4", "plants2:desert_0", "plants2:desert_1", "plants2:double_0", "plants2:cataplant", "botany:flower", "biomesoplenty:bamboo", "biomesoplenty:flower_0", "biomesoplenty:flower_1", "biomesoplenty:plant_0", "biomesoplenty:plant_1", "biomesoplenty:mushroom", "biomesoplenty:doubleplant", "biomesoplenty:flower_vine", "biomesoplenty:ivy", "biomesoplenty:tree_moss", "biomesoplenty:willow_vine", "croparia:fruit_grass", "plants2:androsace_a", "plants2:akebia_q_vine", "plants2:ampelopsis_a_vine", "plants2:adlumia_f", "abyssalcraft:wastelandsthorn", "abyssalcraft:luminousthistle", "harvestcraft:garden", "harvestcraft:windygarden", "minecraft:double_plant", "minecraft:red_flower", "minecraft:yellow_flower", "minecraft:brown_mushroom", "minecraft:red_mushroom", "ferdinandsflowers:block_cff_*", "extraplanets:*_flowers", "primal:cineris_grass", "primal:cineris_bloom", "primal:sinuous_weed", "primal:dry_grass_root", "primal:nether_root", "primal:corypha_stalk", "twilightforest:*_plant", "tconstruct:*_grass_tall", "thebetweenlands:*_flower", "thebetweenlands:*_tallgrass", "thebetweenlands:*_stalk", "thebetweenlands:moss", "thebetweenlands:cattail", "thebetweenlands:*_cattail", "thebetweenlands:*_plant", "thebetweenlands:*_coral", "thebetweenlands:*_bush", "thebetweenlands:*_ivy", "thebetweenlands:algae", "thebetweenlands:hanger", "thebetweenlands:nettle", "thebetweenlands:*_iris", "thebetweenlands:*_kelp", "thebetweenlands:fallen_leaves", "thebetweenlands:swamp_reed_*", "thebetweenlands:*_mushroom", "natura:*_vines", "nex:plant_thornstalk"}, "Blocks that the Brush Scythe will attempt to harvest as if they are leaves.  A star is for a wildcard "));
    }

    private static boolean doesMatch(Block blockCheck, ScytheConfig type) {
        if (UtilString.isInList(type.blockWhitelist, blockCheck.getRegistryName())) {
            return true;
        }
        ItemStack bStack = new ItemStack(blockCheck);
        return UtilOreDictionary.doesMatchOreDict(bStack, (String[])type.oreDictWhitelist.toArray((Object[])new String[0]));
    }

    public static boolean harvestSingle(World world, EntityPlayer player, BlockPos posCurrent, ItemScythe.ScytheType type) {
        boolean doBreakAbove = false;
        boolean doBreakBelow = false;
        boolean doBreak = false;
        IBlockState blockState = world.func_180495_p(posCurrent);
        Block blockCheck = blockState.func_177230_c();
        if (blockCheck == Blocks.field_150350_a) {
            return false;
        }
        String blockId = blockCheck.getRegistryName().toString();
        Item seedItem = blockCheck.func_180660_a(blockCheck.func_176223_P(), world.field_73012_v, 0);
        if (UtilScythe.isItemInBlacklist(UtilItemStack.getStringForItem(seedItem)) || UtilScythe.isItemInBlacklist(blockId)) {
            return false;
        }
        if (blockCheck.getRegistryName() == null) {
            ModCyclic.logger.error("Error: a block has not been registered correctly");
            return false;
        }
        switch (type) {
            case CROPS: {
                break;
            }
            case LEAVES: {
                if (!UtilScythe.doesMatch(blockCheck, leafConfig)) break;
                doBreak = true;
                break;
            }
            case WEEDS: {
                if (!UtilScythe.doesMatch(blockCheck, brushConfig)) break;
                doBreak = true;
                break;
            }
        }
        IBlockState bsAbove = world.func_180495_p(posCurrent.func_177984_a());
        IBlockState bsBelow = world.func_180495_p(posCurrent.func_177977_b());
        switch (type) {
            case WEEDS: {
                if (!weedsClassCheck) break;
                if (blockCheck instanceof BlockTallGrass) {
                    doBreak = true;
                    if (blockCheck instanceof BlockTallGrass && bsAbove != null && bsAbove.func_177230_c() instanceof BlockTallGrass) {
                        doBreakAbove = true;
                    }
                    if (!(bsBelow instanceof BlockTallGrass) || bsBelow == null || !(bsBelow.func_177230_c() instanceof BlockTallGrass)) break;
                    doBreakBelow = true;
                    break;
                }
                if (blockCheck instanceof BlockDoublePlant) {
                    doBreak = true;
                    if (blockCheck instanceof BlockDoublePlant && bsAbove != null && bsAbove.func_177230_c() instanceof BlockDoublePlant) {
                        doBreakAbove = true;
                    }
                    if (!(bsBelow instanceof BlockDoublePlant) || bsBelow == null || !(bsBelow.func_177230_c() instanceof BlockDoublePlant)) break;
                    doBreakBelow = true;
                    break;
                }
                if (!(blockCheck instanceof BlockMushroom)) break;
                doBreak = true;
                break;
            }
            case CROPS: {
                break;
            }
            case LEAVES: {
                if (!(blockCheck instanceof BlockLeaves) || !leavesClassCheck) break;
                doBreak = true;
            }
        }
        if (doBreak) {
            blockCheck.func_180657_a(world, player, posCurrent, blockState, world.func_175625_s(posCurrent), player.func_184614_ca());
            world.func_175655_b(posCurrent, false);
            if (doBreakAbove) {
                world.func_175655_b(posCurrent.func_177984_a(), false);
            }
            if (doBreakBelow) {
                world.func_175655_b(posCurrent.func_177977_b(), false);
            }
            return true;
        }
        if (!blockCheck.getRegistryName().func_110624_b().equals("minecraft")) {
            ModCyclic.logger.log("SCYTHE could not clip " + blockId, new Object[0]);
        }
        return false;
    }

    private static boolean isItemInBlacklist(String itemName) {
        for (String s : blacklistAll) {
            if (s == null || !s.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    static {
        leafConfig = new ScytheConfig();
        brushConfig = new ScytheConfig();
    }

    private static class ScytheConfig {
        NonNullList<String> blockWhitelist;
        NonNullList<String> oreDictWhitelist;

        private ScytheConfig() {
        }
    }
}

