/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.crashtestdummy.EntityRobot;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEntitySyncToClient
implements IMessage,
IMessageHandler<PacketEntitySyncToClient, IMessage> {
    private int entityId;
    private List<EntityRobot.DmgTracker> trackers;

    public PacketEntitySyncToClient() {
    }

    public PacketEntitySyncToClient(int entityid, List<EntityRobot.DmgTracker> trackers) {
        this.entityId = entityid;
        this.trackers = trackers;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.entityId = compound.func_74762_e("entityId");
        this.trackers = new ArrayList<EntityRobot.DmgTracker>();
        int saved = compound.func_74762_e("SAVED");
        for (int i = 0; i < saved; ++i) {
            int timer;
            if (!compound.func_74764_b("tmr" + i) || (timer = compound.func_74762_e("tmr" + i)) <= 0) continue;
            this.trackers.add(new EntityRobot.DmgTracker(timer, compound.func_74779_i("strMsg" + i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("entityId", this.entityId);
        int i = 0;
        for (EntityRobot.DmgTracker t : this.trackers) {
            compound.func_74768_a("tmr" + i, t.timer);
            compound.func_74778_a("strMsg" + i, t.message);
            ++i;
        }
        compound.func_74768_a("SAVED", i);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
    }

    public IMessage onMessage(final PacketEntitySyncToClient message, final MessageContext ctx) {
        if (ctx.side.isClient()) {
            ModCyclic.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketEntitySyncToClient.this.handle(message, ctx);
                }
            });
        }
        return null;
    }

    private void handle(PacketEntitySyncToClient message, MessageContext ctx) {
        Entity entityTarget = ModCyclic.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_73045_a(message.entityId);
        if (entityTarget instanceof EntityRobot) {
            ((EntityRobot)entityTarget).setTrackers(message.trackers);
        }
    }
}

