/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.capability.IPlayerExtendedProperties;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.ItemFlight;
import com.lothrazar.cyclicmagic.item.core.ItemFoodCreative;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNoclipGhost
extends ItemFoodCreative
implements IHasRecipe,
IContent {
    public static int GHOST_SECONDS;
    public static int POTION_SECONDS;
    private static final int numFood = 2;
    private boolean enabled;

    public ItemNoclipGhost() {
        super(2, false);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        this.setPlayerGhostMode(player, world);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltips, ITooltipFlag advanced) {
        tooltips.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this, 3), "lal", "lal", "lal", Character.valueOf('l'), Items.field_151071_bq, Character.valueOf('a'), Items.field_185161_cS);
    }

    @Override
    public void register() {
        ItemRegistry.register((Item)this, this.getContentName());
        ModCyclic.instance.events.register(this);
        LootTableRegistry.registerLoot((Item)this);
        LootTableRegistry.registerLoot((Item)this, LootTableRegistry.ChestType.ENDCITY);
    }

    @Override
    public String getContentName() {
        return "corrupted_chorus";
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("CorruptedChorus(Food)", "cyclicmagic.content", true, " Set false to delete - requires restart");
        String category = "modpacks";
        GHOST_SECONDS = config.getInt("CorruptedChorusSeconds", category, 10, 1, 600, "How long you can noclip after eating corrupted chorus");
        POTION_SECONDS = config.getInt("CorruptedChorusPotions", category, 10, 0, 600, "How long the negative potion effects last after a corrupted chorus teleports you");
    }

    private void setPlayerGhostMode(EntityPlayer player, World par2World) {
        if (!par2World.field_72995_K) {
            player.func_71033_a(GameType.SPECTATOR);
        }
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(player);
        props.setChorusTimer(GHOST_SECONDS * 20);
        props.setChorusOn(true);
        props.setChorusStart(player.func_180425_c());
        props.setChorusDim(player.field_71093_bK);
        ItemFlight.setNonFlying(player);
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        World world = player.func_130014_f_();
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(player);
        if (props.getChorusOn()) {
            int playerGhost = props.getChorusTimer();
            if (playerGhost > 0) {
                ModCyclic.proxy.closeSpectatorGui();
                props.setChorusTimer(playerGhost - 1);
                player.field_70143_R = 0.0f;
            } else {
                props.setChorusOn(false);
                if (props.getChorusDim() != player.field_71093_bK) {
                    player.func_71033_a(GameType.SURVIVAL);
                    player.func_70097_a(DamageSource.field_76376_m, 500.0f);
                } else {
                    BlockPos currentPos = player.func_180425_c();
                    BlockPos sourcePos = props.getChorusStart();
                    if (this.isPosValidTeleport(world, currentPos)) {
                        if (POTION_SECONDS > 0) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20 * POTION_SECONDS));
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20 * POTION_SECONDS));
                        }
                    } else {
                        UtilEntity.teleportWallSafe((EntityLivingBase)player, world, sourcePos);
                    }
                    player.field_70143_R = 0.0f;
                    player.func_71033_a(GameType.SURVIVAL);
                }
            }
        }
    }

    private boolean isPosValidTeleport(World world, BlockPos pos) {
        return world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a()) && pos.func_177956_o() > 0;
    }
}

