/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.config;

import com.blakebr0.cucumber.lib.ItemPlaceholder;
import com.blakebr0.ironjetpacks.config.json.Serializers;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class ModJetpacks {
    private static final Jetpack WOOD = JetpackRegistry.createJetpack("wood", 0, 7033119, 1, 15, ItemPlaceholder.of((String)"plankWood"));
    private static final Jetpack STONE = JetpackRegistry.createJetpack("stone", 1, 0x7F7F7F, 2, 12, ItemPlaceholder.of((Block)Blocks.field_150348_b));
    private static final Jetpack IRON = JetpackRegistry.createJetpack("iron", 2, 0xC1C1C1, 3, 9, ItemPlaceholder.of((String)"ingotIron"));
    private static final Jetpack GOLD = JetpackRegistry.createJetpack("gold", 3, 0xDEDE00, 2, 25, ItemPlaceholder.of((String)"ingotGold"));
    private static final Jetpack DIAMOND = JetpackRegistry.createJetpack("diamond", 4, 4910545, 4, 10, ItemPlaceholder.of((String)"gemDiamond"));
    private static final Jetpack EMERALD = JetpackRegistry.createJetpack("emerald", 5, 4322180, 4, 15, ItemPlaceholder.of((String)"gemEmerald"));
    private static final Jetpack CREATIVE = JetpackRegistry.createJetpack("creative", 0, 13572841, 8, 0, null).setCreative();
    private static final Jetpack COPPER = JetpackRegistry.createJetpack("copper", 1, 13529601, 2, 12, ItemPlaceholder.of((String)"ingotCopper"));
    private static final Jetpack BRONZE = JetpackRegistry.createJetpack("bronze", 2, 15507007, 3, 9, ItemPlaceholder.of((String)"ingotBronze"));
    private static final Jetpack SILVER = JetpackRegistry.createJetpack("silver", 2, 10470621, 3, 12, ItemPlaceholder.of((String)"ingotSilver"));
    private static final Jetpack STEEL = JetpackRegistry.createJetpack("steel", 3, 0x565656, 3, 15, ItemPlaceholder.of((String)"ingotSteel"));
    private static final Jetpack ELECTRUM = JetpackRegistry.createJetpack("electrum", 3, 10981685, 2, 18, ItemPlaceholder.of((String)"ingotElectrum"));
    private static final Jetpack INVAR = JetpackRegistry.createJetpack("invar", 3, 9608599, 3, 15, ItemPlaceholder.of((String)"ingotInvar"));
    private static final Jetpack PLATINUM = JetpackRegistry.createJetpack("platinum", 4, 7334639, 4, 12, ItemPlaceholder.of((String)"ingotPlatinum"));

    public static void init(File dir) {
        File[] files;
        JetpackRegistry registry = JetpackRegistry.getInstance();
        Gson gson = Serializers.initGson();
        if (!dir.exists() && dir.mkdirs()) {
            for (Jetpack jetpack : ModJetpacks.defaults()) {
                String json = gson.toJson((Object)jetpack);
                try {
                    File file = new File(dir, jetpack.name + ".json");
                    FileWriter writer = new FileWriter(file);
                    writer.write(json);
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        try {
            ModJetpacks.updateOldJsons(files, dir, gson);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ArrayList<Jetpack> jetpacks = new ArrayList<Jetpack>();
        for (File file : files) {
            Jetpack jetpack = null;
            try {
                FileReader reader = new FileReader(file);
                jetpack = (Jetpack)gson.fromJson((Reader)reader, Jetpack.class);
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (jetpack.disabled) continue;
            jetpacks.add(jetpack);
        }
        jetpacks.sort(Comparator.comparingInt(Jetpack::getTier));
        for (Jetpack j : jetpacks) {
            registry.register(j);
        }
    }

    public static List<Jetpack> defaults() {
        ArrayList<Jetpack> defaults = new ArrayList<Jetpack>();
        defaults.add(WOOD);
        defaults.add(STONE);
        defaults.add(IRON);
        defaults.add(GOLD);
        defaults.add(DIAMOND);
        defaults.add(EMERALD);
        defaults.add(CREATIVE);
        defaults.add(COPPER);
        defaults.add(BRONZE);
        defaults.add(SILVER);
        defaults.add(STEEL);
        defaults.add(ELECTRUM);
        defaults.add(INVAR);
        defaults.add(PLATINUM);
        defaults.sort(Comparator.comparingInt(Jetpack::getTier));
        return defaults;
    }

    private static void updateOldJsons(File[] files, File dir, Gson gson) throws IOException {
        for (File file : files) {
            String json = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            JsonObject obj = new JsonParser().parse(json).getAsJsonObject();
            if (!obj.has("jetpack_type")) continue;
            JsonObject jetpackType = obj.get("jetpack_type").getAsJsonObject();
            String name = jetpackType.get("name").getAsString();
            boolean disable = jetpackType.get("disable").getAsBoolean();
            int tier = jetpackType.get("tier").getAsInt();
            int color = jetpackType.get("color").getAsInt();
            int armorPoints = jetpackType.get("armor_points").getAsInt();
            int enchantability = jetpackType.get("enchantability").getAsInt();
            String craftingItem = jetpackType.get("crafting_material").getAsString();
            ItemPlaceholder craftingMaterial = null;
            if (!craftingItem.equalsIgnoreCase("null")) {
                if (craftingItem.startsWith("ore:")) {
                    craftingMaterial = ItemPlaceholder.of((String)craftingItem.substring(4));
                } else {
                    String[] parts = craftingItem.split(":");
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]));
                    craftingMaterial = ItemPlaceholder.of((ItemStack)new ItemStack(item, 1, Integer.valueOf(parts[2]).intValue()));
                }
            }
            boolean forceRecipes = jetpackType.get("force_recipes").getAsBoolean();
            boolean creative = false;
            if (jetpackType.has("creative")) {
                creative = jetpackType.get("creative").getAsBoolean();
            }
            Jetpack jetpack = JetpackRegistry.createJetpack(name, tier, color, armorPoints, enchantability, craftingMaterial).setCreative(creative);
            JsonObject jetpackInfo = obj.get("jetpack_info").getAsJsonObject();
            int capacity = jetpackInfo.get("capacity").getAsInt();
            int usage = jetpackInfo.get("usage").getAsInt();
            double speedVert = jetpackInfo.get("speed_vertical").getAsDouble();
            double accelVert = jetpackInfo.get("accel_vertical").getAsDouble();
            double speedSide = jetpackInfo.get("speed_sideways").getAsDouble();
            double speedHover = jetpackInfo.get("speed_hover_descend").getAsDouble();
            double speedHoverSlow = jetpackInfo.get("speed_hover").getAsDouble();
            double sprintSpeed = jetpackInfo.get("sprint_speed_multi").getAsDouble();
            double sprintFuel = jetpackInfo.get("sprint_fuel_multi").getAsDouble();
            jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHover, speedHoverSlow, sprintSpeed, sprintFuel);
            String newJson = gson.toJson((Object)jetpack);
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(newJson);
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        WOOD.setStats(20000, 32, 0.18, 0.1, 0.06, 0.16, 0.14, 1.0, 1.0);
        STONE.setStats(100000, 70, 0.25, 0.11, 0.08, 0.18, 0.1, 1.0, 1.0);
        IRON.setStats(800000, 120, 0.41, 0.12, 0.14, 0.27, 0.075, 1.1, 2.1);
        GOLD.setStats(10000000, 300, 0.61, 0.13, 0.15, 0.34, 0.03, 1.5, 3.2);
        DIAMOND.setStats(30000000, 650, 0.9, 0.15, 0.19, 0.41, 0.005, 1.8, 3.8);
        EMERALD.setStats(48000000, 880, 1.03, 0.17, 0.21, 0.45, 0.0, 2.0, 4.0);
        CREATIVE.setStats(0, 0, 1.03, 0.17, 0.21, 0.45, 0.0, 2.0, 0.0);
        COPPER.setStats(250000, 85, 0.29, 0.11, 0.1, 0.23, 0.092, 1.05, 1.4);
        BRONZE.setStats(800000, 120, 0.41, 0.12, 0.14, 0.27, 0.075, 1.1, 2.1);
        SILVER.setStats(1200000, 150, 0.48, 0.13, 0.15, 0.3, 0.07, 1.3, 2.7);
        STEEL.setStats(12000000, 350, 0.67, 0.135, 0.155, 0.35, 0.025, 1.5, 3.2);
        ELECTRUM.setStats(10000000, 310, 0.79, 0.14, 0.17, 0.37, 0.03, 1.6, 3.5);
        INVAR.setStats(12000000, 350, 0.61, 0.13, 0.15, 0.34, 0.03, 1.5, 3.2);
        PLATINUM.setStats(36000000, 720, 0.92, 0.155, 0.193, 0.42, 0.005, 1.8, 3.8);
    }
}

