/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import gnu.trove.set.hash.TCustomHashSet;
import gnu.trove.strategy.HashingStrategy;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.logic.filter.Filter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public class SetofItemStack
extends TCustomHashSet<ItemStack> {
    private static final Comparator<? super ItemStack> compareStacks = (o1, o2) -> {
        int c = o1.func_77973_b().getRegistryName().func_110624_b().compareTo(o2.func_77973_b().getRegistryName().func_110624_b());
        if (c != 0) {
            return c;
        }
        return o1.func_82833_r().compareTo(o2.func_82833_r());
    };

    public SetofItemStack(Filter.Flags filterFlags) {
        super((HashingStrategy)new ItemStackHashingStrategy(filterFlags));
    }

    public SetofItemStack(int initialCapacity, Filter.Flags filterFlags) {
        super((HashingStrategy)new ItemStackHashingStrategy(filterFlags), initialCapacity);
    }

    public SetofItemStack(int initialCapacity, float loadFactor, Filter.Flags filterFlags) {
        super((HashingStrategy)new ItemStackHashingStrategy(filterFlags), initialCapacity, loadFactor);
    }

    public SetofItemStack(Collection<? extends ItemStack> collection, Filter.Flags filterFlags) {
        super((HashingStrategy)new ItemStackHashingStrategy(filterFlags), collection);
    }

    public static SetofItemStack fromItemHandler(IItemHandler handler, Filter.Flags filterFlags) {
        NonNullList itemStacks = NonNullList.func_191196_a();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            itemStacks.add((Object)stack);
        }
        return new SetofItemStack((Collection<? extends ItemStack>)itemStacks, filterFlags);
    }

    public List<ItemStack> sortedList() {
        return this.stream().sorted(compareStacks).collect(Collectors.toList());
    }

    private static class ItemStackHashingStrategy
    implements HashingStrategy<ItemStack> {
        private final Filter.Flags filterFlags;

        public ItemStackHashingStrategy(Filter.Flags filterFlags) {
            this.filterFlags = filterFlags;
        }

        public int computeHashCode(ItemStack object) {
            int hashCode = Item.func_150891_b((Item)object.func_77973_b());
            if (!this.filterFlags.isIgnoreMeta()) {
                hashCode += 37 * object.func_77952_i();
            }
            if (!this.filterFlags.isIgnoreNBT() && object.func_77942_o()) {
                hashCode += 37 * object.func_77978_p().hashCode();
            }
            return hashCode;
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.func_77973_b() == o2.func_77973_b() && (this.filterFlags.isIgnoreMeta() || o1.func_77952_i() == o2.func_77952_i()) && (this.filterFlags.isIgnoreNBT() || !o1.func_77942_o() || o1.func_77978_p().equals((Object)o2.func_77978_p()));
        }
    }
}

