/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleHelper {
    public static final String NBT_FLAGS = "Flags";
    public static final String NBT_REDSTONE_MODE = "RedstoneMode";
    public static final String NBT_REGULATOR_AMOUNT = "RegulatorAmount";
    public static final String NBT_FILTER = "ModuleFilter";
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_CONFIG_SLOT = "ConfigSlot";
    public static final String NBT_AUGMENTS = "Augments";
    public static final String NBT_PICKAXE = "Pickaxe";
    private static final Pair<String, UUID> NO_OWNER = Pair.of((Object)"", null);

    @Nonnull
    public static NBTTagCompound validateNBT(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        if (compound.func_150299_b(NBT_FLAGS) != 1) {
            byte flags = 0;
            for (Module.ModuleFlags b : Module.ModuleFlags.values()) {
                if (!b.getDefaultValue()) continue;
                flags = (byte)(flags | b.getMask());
            }
            compound.func_74774_a(NBT_FLAGS, flags);
        }
        if (compound.func_150299_b(NBT_FILTER) != 9) {
            compound.func_74782_a(NBT_FILTER, (NBTBase)new NBTTagList());
        }
        return compound;
    }

    public static boolean isBlacklist(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, Module.ModuleFlags.BLACKLIST);
    }

    public static boolean ignoreMeta(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, Module.ModuleFlags.IGNORE_META);
    }

    public static boolean ignoreNBT(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, Module.ModuleFlags.IGNORE_NBT);
    }

    public static boolean ignoreOreDict(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, Module.ModuleFlags.IGNORE_OREDICT);
    }

    public static boolean terminates(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, Module.ModuleFlags.TERMINATE);
    }

    public static boolean checkFlag(ItemStack stack, Module.ModuleFlags flag) {
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        return (compound.func_74771_c(NBT_FLAGS) & flag.getMask()) != 0;
    }

    public static Module.RelativeDirection getDirectionFromNBT(ItemStack stack) {
        Module module = ItemModule.getModule(stack);
        if (module == null || !module.isDirectional()) {
            return Module.RelativeDirection.NONE;
        }
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        return Module.RelativeDirection.values()[(compound.func_74771_c(NBT_FLAGS) & 0x70) >> 4];
    }

    public static int getRegulatorAmount(ItemStack itemstack) {
        NBTTagCompound compound = ModuleHelper.validateNBT(itemstack);
        return compound.func_74762_e(NBT_REGULATOR_AMOUNT);
    }

    public static RouterRedstoneBehaviour getRedstoneBehaviour(ItemStack stack) {
        ItemAugment.AugmentCounter counter = new ItemAugment.AugmentCounter(stack);
        if (counter.getAugmentCount(ItemAugment.AugmentType.REDSTONE) > 0) {
            NBTTagCompound compound = ModuleHelper.validateNBT(stack);
            try {
                return RouterRedstoneBehaviour.values()[compound.func_74771_c(NBT_REDSTONE_MODE)];
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                return RouterRedstoneBehaviour.ALWAYS;
            }
        }
        return RouterRedstoneBehaviour.ALWAYS;
    }

    public static NBTTagList getFilterItems(ItemStack stack) {
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        return compound.func_150295_c(NBT_FILTER, 10);
    }

    public static void setOwner(ItemStack stack, EntityPlayer player) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        NBTTagList owner = new NBTTagList();
        owner.func_74742_a((NBTBase)new NBTTagString(player.getDisplayNameString()));
        owner.func_74742_a((NBTBase)new NBTTagString(player.func_110124_au().toString()));
        compound.func_74782_a(NBT_OWNER, (NBTBase)owner);
        stack.func_77982_d(compound);
    }

    public static Pair<String, UUID> getOwnerNameAndId(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_OWNER)) {
            return NO_OWNER;
        }
        NBTTagList l = stack.func_77978_p().func_150295_c(NBT_OWNER, 8);
        return Pair.of((Object)l.func_150307_f(0), (Object)UUID.fromString(l.func_150307_f(1)));
    }

    public static ItemStack makeItemStack(ItemModule.ModuleType type) {
        return ModuleHelper.makeItemStack(type, 1);
    }

    public static ItemStack makeItemStack(ItemModule.ModuleType type, int amount) {
        return new ItemStack((Item)RegistrarMR.MODULE, amount, type.ordinal());
    }

    public static boolean isModuleType(ItemStack stack, ItemModule.ModuleType ... types) {
        if (stack.func_77973_b() instanceof ItemModule) {
            for (ItemModule.ModuleType type : types) {
                if (stack.func_77952_i() != type.ordinal()) continue;
                return true;
            }
        }
        return false;
    }

    public static void setFilterConfigSlot(ItemStack stack, int slot) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (slot < 0) {
            compound.func_82580_o(NBT_CONFIG_SLOT);
        } else {
            compound.func_74768_a(NBT_CONFIG_SLOT, slot);
        }
        stack.func_77982_d(compound);
    }

    public static int getFilterConfigSlot(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_CONFIG_SLOT)) {
            return stack.func_77978_p().func_74762_e(NBT_CONFIG_SLOT);
        }
        return -1;
    }

    public static int getRangeModifier(ItemStack stack) {
        ItemAugment.AugmentCounter counter = new ItemAugment.AugmentCounter(stack);
        return counter.getAugmentCount(ItemAugment.AugmentType.RANGE_UP) - counter.getAugmentCount(ItemAugment.AugmentType.RANGE_DOWN);
    }

    public static void setPickaxe(ItemStack moduleStack, ItemStack pickaxe) {
        NBTTagCompound compound = ModuleHelper.validateNBT(moduleStack);
        compound.func_74782_a(NBT_PICKAXE, (NBTBase)pickaxe.serializeNBT());
    }

    public static ItemStack getPickaxe(ItemStack moduleStack) {
        NBTTagCompound compound = ModuleHelper.validateNBT(moduleStack);
        return compound.func_74764_b(NBT_PICKAXE) ? new ItemStack(compound.func_74775_l(NBT_PICKAXE)) : new ItemStack(Items.field_151035_b);
    }
}

