/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.lang.ref.WeakReference;
import java.util.UUID;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class CompiledPlayerModule
extends CompiledModule {
    public static final String NBT_OPERATION = "Operation";
    public static final String NBT_SECTION = "Section";
    private final Operation operation;
    private final Section section;
    private final UUID playerId;
    private final String playerName;
    private WeakReference<EntityPlayer> playerRef;

    public CompiledPlayerModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            Pair<String, UUID> owner = ModuleHelper.getOwnerNameAndId(stack);
            this.playerName = (String)owner.getLeft();
            this.playerId = (UUID)owner.getRight();
            this.operation = Operation.values()[compound.func_74762_e(NBT_OPERATION)];
            this.section = Section.values()[compound.func_74762_e(NBT_SECTION)];
            if (router != null && !router.func_145831_w().field_72995_K) {
                EntityPlayerMP player = this.playerId == null ? null : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerId);
                this.playerRef = new WeakReference<EntityPlayerMP>(player);
            } else {
                this.playerRef = new WeakReference<Object>(null);
            }
        } else {
            this.operation = Operation.EXTRACT;
            this.section = Section.MAIN;
            this.playerId = null;
            this.playerName = null;
        }
    }

    @Override
    public boolean hasTarget() {
        return this.getPlayer() != null;
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        EntityPlayer player = this.getPlayer();
        IItemHandler itemHandler = this.getHandler(player);
        if (itemHandler == null) {
            return false;
        }
        ItemStack bufferStack = router.getBufferItemStack();
        switch (this.operation) {
            case EXTRACT: {
                if (bufferStack.func_190916_E() >= bufferStack.func_77976_d()) break;
                int taken = this.transferToRouter(itemHandler, router);
                return taken > 0;
            }
            case INSERT: {
                int sent;
                if (!this.getFilter().test(bufferStack)) break;
                if (this.getSection() == Section.ARMOR) {
                    return this.insertArmor(router, itemHandler, bufferStack);
                }
                int nToSend = this.getItemsPerTick(router);
                if (this.getRegulationAmount() > 0) {
                    int existing = InventoryUtils.countItems(bufferStack, itemHandler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreMeta());
                    if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                        return false;
                    }
                }
                return (sent = InventoryUtils.transferItems(router.getBuffer(), itemHandler, 0, nToSend)) > 0;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public EntityPlayer getPlayer() {
        return (EntityPlayer)this.playerRef.get();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_110124_au().equals(this.playerId)) {
            this.playerRef = new WeakReference<EntityPlayer>(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.func_110124_au().equals(this.playerId)) {
            this.playerRef = new WeakReference<Object>(null);
        }
    }

    @Override
    public void onCompiled(TileEntityItemRouter router) {
        super.onCompiled(router);
        if (!router.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void cleanup(TileEntityItemRouter router) {
        super.cleanup(router);
        if (!router.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Section getSection() {
        return this.section;
    }

    private boolean insertArmor(TileEntityItemRouter router, IItemHandler itemHandler, ItemStack armorStack) {
        int slot = this.getSlotForArmorItem(armorStack);
        if (slot >= 0 && itemHandler.getStackInSlot(slot).func_190926_b()) {
            ItemStack extracted = router.getBuffer().extractItem(0, 1, false);
            if (extracted.func_190926_b()) {
                return false;
            }
            ItemStack res = itemHandler.insertItem(slot, extracted, false);
            return res.func_190926_b();
        }
        return false;
    }

    private int getSlotForArmorItem(ItemStack stack) {
        switch (EntityLiving.func_184640_d((ItemStack)stack)) {
            case HEAD: {
                return 3;
            }
            case CHEST: {
                return 2;
            }
            case LEGS: {
                return 1;
            }
            case FEET: {
                return 0;
            }
        }
        return -1;
    }

    private IItemHandler getHandler(EntityPlayer player) {
        switch (this.section) {
            case MAIN: {
                return new PlayerMainInvWrapper(player.field_71071_by);
            }
            case ARMOR: {
                return new PlayerArmorInvWrapper(player.field_71071_by);
            }
            case OFFHAND: {
                return new PlayerOffhandInvWrapper(player.field_71071_by);
            }
            case ENDER: {
                return new InvWrapper((IInventory)player.func_71005_bN());
            }
        }
        return null;
    }

    public static enum Section {
        MAIN,
        ARMOR,
        OFFHAND,
        ENDER;

    }

    public static enum Operation {
        EXTRACT,
        INSERT;


        public String getSymbol() {
            return this == INSERT ? "\u27f9" : "\u27f8";
        }
    }
}

