/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.ItemSubTypes;
import me.desht.modularrouters.item.smartfilter.BulkItemFilter;
import me.desht.modularrouters.item.smartfilter.InspectionFilter;
import me.desht.modularrouters.item.smartfilter.ModFilter;
import me.desht.modularrouters.item.smartfilter.RegexFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class ItemSmartFilter
extends ItemSubTypes<FilterType> {
    public ItemSmartFilter() {
        super("filter", FilterType.class);
        this.register(FilterType.BULKITEM, new BulkItemFilter());
        this.register(FilterType.MOD, new ModFilter());
        this.register(FilterType.REGEX, new RegexFilter());
        this.register(FilterType.INSPECTION, new InspectionFilter());
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == Side.CLIENT) {
            SmartFilter filter = ItemSmartFilter.getFilter(event.getItemStack());
            if (filter == null) {
                return;
            }
            if (InventoryUtils.getInventory(event.getWorld(), event.getPos(), event.getFace()) != null) {
                return;
            }
            event.setCanceled(true);
        }
    }

    public static SmartFilter getFilter(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemSmartFilter)) {
            return null;
        }
        if (stack.func_77960_j() >= FilterType.values().length) {
            return null;
        }
        return ItemSmartFilter.getFilter(FilterType.values()[stack.func_77960_j()]);
    }

    public static SmartFilter getFilter(FilterType type) {
        return (SmartFilter)RegistrarMR.FILTER.getHandler(type);
    }

    public static boolean isType(ItemStack stack, FilterType type) {
        return stack.func_77973_b() instanceof ItemSmartFilter && stack.func_77952_i() == type.ordinal();
    }

    public static ItemStack makeItemStack(FilterType type) {
        return ItemSmartFilter.makeItemStack(type, 1);
    }

    public static ItemStack makeItemStack(FilterType type, int amount) {
        return new ItemStack((Item)RegistrarMR.FILTER, amount, type.ordinal());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        int guiId;
        ItemStack stack = player.func_184586_b(hand);
        SmartFilter filter = ItemSmartFilter.getFilter(stack);
        int n = guiId = hand == EnumHand.MAIN_HAND ? ModularRouters.GUI_FILTER_HELD_MAIN : ModularRouters.GUI_FILTER_HELD_OFF;
        if (!world.field_72995_K && filter.hasGuiContainer() || world.field_72995_K && !filter.hasGuiContainer()) {
            player.openGui((Object)ModularRouters.instance, guiId, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
        ItemStack stack = player.func_184586_b(hand);
        return this.getHandler(stack).onItemUse(stack, player, world, pos, hand, face, x, y, z);
    }

    public static enum FilterType {
        BULKITEM,
        MOD,
        REGEX,
        INSPECTION;


        public static FilterType getType(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemSmartFilter ? FilterType.values()[stack.func_77952_i()] : null;
        }
    }
}

