/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.GuiItemRouter;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.network.PlaySoundMessage;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public abstract class TargetedModule
extends Module {
    private static final String NBT_TARGET = "Target";
    private static final String NBT_MULTI_TARGET = "MultiTarget";
    private static final Map<UUID, Long> lastSwing = Maps.newHashMap();

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
        if (player.func_70093_af()) {
            if (InventoryUtils.getInventory(world, pos, face) != null) {
                if (this.getMaxTargets() == 1) {
                    this.handleSingleTarget(stack, player, world, pos, face);
                } else {
                    this.handleMultiTarget(stack, player, world, pos, face);
                }
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(stack, player, world, pos, hand, face, x, y, z);
        }
        return EnumActionResult.PASS;
    }

    private void handleMultiTarget(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (!world.field_72995_K) {
            boolean removing = false;
            String invName = BlockUtil.getBlockName(world, pos);
            ModuleTarget tgt = new ModuleTarget(world.field_73011_w.getDimension(), pos, face, invName);
            Set<ModuleTarget> targets = TargetedModule.getTargets(stack, true);
            if (targets.contains(tgt)) {
                targets.remove(tgt);
                removing = true;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.targetRemoved", new Object[]{tgt.toString(), targets.size(), this.getMaxTargets()}), true);
            } else if (targets.size() < this.getMaxTargets()) {
                targets.add(tgt);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.targetAdded", new Object[]{tgt.toString(), targets.size(), this.getMaxTargets()}), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.tooManyTargets", new Object[]{this.getMaxTargets()}), true);
                PlaySoundMessage.playSound(player, RegistrarMR.SOUND_ERROR, 1.0f, 1.3f);
                return;
            }
            PlaySoundMessage.playSound(player, RegistrarMR.SOUND_SUCCESS, 1.0f, removing ? 1.1f : 1.3f);
            TargetedModule.setTargets(stack, targets);
        }
    }

    private void handleSingleTarget(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (!world.field_72995_K) {
            TargetedModule.setTarget(stack, world, pos, face);
            ModuleTarget tgt = TargetedModule.getTarget(stack, true);
            if (tgt != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.targetSet", new Object[]{tgt.toString()}), true);
                PlaySoundMessage.playSound(player, RegistrarMR.SOUND_SUCCESS, 1.0f, 1.3f);
            }
        }
    }

    @Override
    public void addUsageInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addUsageInformation(itemstack, player, list, advanced);
        MiscUtil.appendMultiline(list, this.getMaxTargets() > 1 ? "itemText.targetingHintMulti" : "itemText.targetingHint", new Object[0]);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(itemstack, player, list, advanced);
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(itemstack, false) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(itemstack)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            list.add(I18n.func_135052_a((String)"chatText.misc.target", (Object[])new Object[]{target.toString()}));
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiItemRouter)) continue;
            TileEntityItemRouter router = ((GuiItemRouter)Minecraft.func_71410_x().field_71462_r).router;
            ModuleTarget moduleTarget = new ModuleTarget(router.func_145831_w().field_73011_w.getDimension(), router.func_174877_v());
            TargetValidation val = this.validateTarget(itemstack, moduleTarget, target, false);
            if (val == TargetValidation.OK) continue;
            list.add(I18n.func_135052_a((String)("chatText.targetValidation." + (Object)((Object)val)), (Object[])new Object[0]));
        }
    }

    @Override
    public ActionResult<ItemStack> onSneakRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && TargetedModule.getTarget(stack) != null && this.getMaxTargets() == 1) {
            TargetedModule.setTarget(stack, world, null, null);
            PlaySoundMessage.playSound(player, RegistrarMR.SOUND_SUCCESS, 1.0f, 1.1f);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.misc.targetCleared", new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static void setTarget(ItemStack stack, World world, BlockPos pos, EnumFacing face) {
        if (world.field_72995_K) {
            ModularRouters.logger.warn("TargetModule.setTarget() should not be called client-side!");
            return;
        }
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        if (pos == null) {
            compound.func_82580_o(NBT_TARGET);
        } else {
            String invName = BlockUtil.getBlockName(world, pos);
            ModuleTarget mt = new ModuleTarget(world.field_73011_w.getDimension(), pos, face, invName == null ? "?" : invName);
            compound.func_74782_a(NBT_TARGET, (NBTBase)mt.toNBT());
        }
        stack.func_77982_d(compound);
    }

    public static ModuleTarget getTarget(ItemStack stack) {
        return TargetedModule.getTarget(stack, false);
    }

    public static ModuleTarget getTarget(ItemStack stack, boolean checkBlockName) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_150299_b(NBT_TARGET) == 10) {
            ModuleTarget newTarget;
            ModuleTarget target = ModuleTarget.fromNBT(compound.func_74775_l(NBT_TARGET));
            if (checkBlockName && (newTarget = TargetedModule.updateTargetBlockName(stack, target)) != null) {
                return newTarget;
            }
            return target;
        }
        return null;
    }

    public static Set<ModuleTarget> getTargets(ItemStack stack, boolean checkBlockName) {
        HashSet result = Sets.newHashSet();
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_150299_b(NBT_MULTI_TARGET) == 9) {
            NBTTagList list = compound.func_150295_c(NBT_MULTI_TARGET, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ModuleTarget target = ModuleTarget.fromNBT(list.func_150305_b(i));
                if (checkBlockName) {
                    ModuleTarget newTarget = TargetedModule.updateTargetBlockName(stack, target);
                    result.add(newTarget != null ? newTarget : target);
                    continue;
                }
                result.add(target);
            }
        }
        return result;
    }

    private static void setTargets(ItemStack stack, Set<ModuleTarget> targets) {
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        NBTTagList list = new NBTTagList();
        for (ModuleTarget target : targets) {
            list.func_74742_a((NBTBase)target.toNBT());
        }
        compound.func_74782_a(NBT_MULTI_TARGET, (NBTBase)list);
        stack.func_77982_d(compound);
    }

    private static ModuleTarget updateTargetBlockName(ItemStack stack, ModuleTarget target) {
        String invName;
        WorldServer w = DimensionManager.getWorld((int)target.dimId);
        if (w != null && w.func_72863_F().func_73149_a(target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4) && !target.invName.equals(invName = BlockUtil.getBlockName((World)w, target.pos))) {
            TargetedModule.setTarget(stack, (World)w, target.pos, target.face);
            return new ModuleTarget(target.dimId, target.pos, target.face, invName);
        }
        return null;
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!(entityLiving instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastSwing.getOrDefault(player.func_110124_au(), 0L) < 250L) {
            return true;
        }
        lastSwing.put(player.func_110124_au(), now);
        ModuleTarget src = new ModuleTarget(world.field_73011_w.getDimension(), player.func_180425_c());
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(stack, true) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(stack, true)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            TargetValidation res = this.validateTarget(stack, src, target, true);
            player.func_146105_b(new TextComponentTranslation("chatText.misc.target", new Object[]{target.toString()}).func_150258_a("  ").func_150257_a((ITextComponent)new TextComponentTranslation("chatText.targetValidation." + (Object)((Object)res), new Object[0])), false);
        }
        return true;
    }

    private TargetValidation validateTarget(ItemStack moduleStack, ModuleTarget src, ModuleTarget dst, boolean validateBlocks) {
        if (this.isRangeLimited() && (src.dimId != dst.dimId || src.pos.func_177951_i((Vec3i)dst.pos) > (double)this.maxDistanceSq(moduleStack))) {
            return TargetValidation.OUT_OF_RANGE;
        }
        if (validateBlocks) {
            WorldServer w = DimensionManager.getWorld((int)dst.dimId);
            if (w == null || !w.func_72863_F().func_73149_a(dst.pos.func_177958_n() >> 4, dst.pos.func_177952_p() >> 4)) {
                return TargetValidation.NOT_LOADED;
            }
            if (w.func_175625_s(dst.pos) == null) {
                return TargetValidation.NOT_INVENTORY;
            }
        }
        return TargetValidation.OK;
    }

    private int maxDistanceSq(ItemStack stack) {
        Module module = ItemModule.getModule(stack);
        if (module instanceof IRangedModule) {
            int r = ((IRangedModule)((Object)module)).getCurrentRange(stack);
            return r * r;
        }
        return 0;
    }

    protected int getMaxTargets() {
        return 1;
    }

    protected boolean isRangeLimited() {
        return true;
    }

    static enum TargetValidation {
        OK,
        OUT_OF_RANGE,
        NOT_LOADED,
        NOT_INVENTORY;

    }
}

