/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.slot;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.SlotItemHandler;

public abstract class BaseModuleSlot<T extends BaseModuleHandler>
extends SlotItemHandler {
    private final TileEntityItemRouter router;
    private final EntityPlayer player;
    private final EnumHand hand;
    private final boolean serverSide;
    private final int index;

    public BaseModuleSlot(T itemHandler, TileEntityItemRouter router, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.router = router;
        this.player = null;
        this.hand = null;
        this.serverSide = !router.func_145831_w().field_72995_K;
        this.index = index;
    }

    public BaseModuleSlot(T itemHandler, EntityPlayer player, EnumHand hand, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.router = null;
        this.player = player;
        this.hand = hand;
        this.serverSide = !player.func_130014_f_().field_72995_K;
        this.index = index;
    }

    public void func_75215_d(ItemStack stack) {
        BaseModuleHandler handler;
        NBTTagCompound compound;
        if (ItemSmartFilter.isType(stack, ItemSmartFilter.FilterType.BULKITEM) && ((compound = stack.func_77978_p()) == null || !compound.func_74764_b("ModuleFilter"))) {
            compound = new NBTTagCompound();
            compound.func_74782_a("ModuleFilter", (NBTBase)new NBTTagList());
            stack.func_77982_d(compound);
        }
        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(handler = (BaseModuleHandler)this.getItemHandler()).getStackInSlot(this.index))) {
            handler.setStackInSlot(this.index, stack);
            this.func_75218_e();
        }
    }

    public void func_75218_e() {
        super.func_75218_e();
        BaseModuleHandler handler = (BaseModuleHandler)this.getItemHandler();
        handler.save();
        if (this.player != null && this.hand != null) {
            this.player.func_184611_a(this.hand, handler.getHolderStack());
        } else if (this.router != null && this.serverSide) {
            this.router.recompileNeeded(1);
        }
    }

    public static class BulkFilterSlot
    extends BaseModuleSlot<BaseModuleHandler.BulkFilterHandler> {
        public BulkFilterSlot(BaseModuleHandler.BulkFilterHandler itemHandler, TileEntityItemRouter router, int index, int xPosition, int yPosition) {
            super(itemHandler, router, index, xPosition, yPosition);
        }

        public BulkFilterSlot(BaseModuleHandler.BulkFilterHandler itemHandler, EntityPlayer player, EnumHand hand, int index, int xPosition, int yPosition) {
            super(itemHandler, player, hand, index, xPosition, yPosition);
        }
    }

    public static class ModuleFilterSlot
    extends BaseModuleSlot<BaseModuleHandler.ModuleFilterHandler> {
        public ModuleFilterSlot(BaseModuleHandler.ModuleFilterHandler itemHandler, TileEntityItemRouter router, int index, int xPosition, int yPosition) {
            super(itemHandler, router, index, xPosition, yPosition);
        }

        public ModuleFilterSlot(BaseModuleHandler.ModuleFilterHandler itemHandler, EntityPlayer player, EnumHand hand, int index, int xPosition, int yPosition) {
            super(itemHandler, player, hand, index, xPosition, yPosition);
        }
    }
}

