/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.textfield.FloatTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledFlingerModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class GuiModuleFlinger
extends GuiModule
implements GuiPageButtonList.GuiResponder {
    private static final int FIELD_SPEED = 1000;
    private static final int FIELD_PITCH = 1001;
    private static final int FIELD_YAW = 1002;
    private float speed;
    private float pitch;
    private float yaw;

    public GuiModuleFlinger(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModuleFlinger(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledFlingerModule fs = new CompiledFlingerModule(null, this.moduleItemStack);
        this.speed = fs.getSpeed();
        this.pitch = fs.getPitch();
        this.yaw = fs.getYaw();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new TooltipButton(1000, this.field_147003_i + 130, this.field_147009_r + 15, "speed", 0.0f, 20.0f));
        this.field_146292_n.add(new TooltipButton(1001, this.field_147003_i + 130, this.field_147009_r + 33, "pitch", -90.0f, 90.0f));
        this.field_146292_n.add(new TooltipButton(1002, this.field_147003_i + 130, this.field_147009_r + 51, "yaw", -60.0f, 60.0f));
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        FloatTextField t1 = new FloatTextField(manager, 1000, this.field_146289_q, this.field_147003_i + 152, this.field_147009_r + 19, 35, 12, 0.0f, 20.0f);
        t1.setPrecision(2);
        t1.setValue(this.speed);
        t1.func_175207_a(this);
        t1.setIncr(0.1f, 0.5f, 10.0f);
        t1.useGuiTextBackground();
        FloatTextField t2 = new FloatTextField(manager, 1001, this.field_146289_q, this.field_147003_i + 152, this.field_147009_r + 37, 35, 12, -90.0f, 90.0f);
        t2.setValue(this.pitch);
        t2.func_175207_a(this);
        t2.useGuiTextBackground();
        FloatTextField t3 = new FloatTextField(manager, 1002, this.field_146289_q, this.field_147003_i + 152, this.field_147009_r + 55, 35, 12, -60.0f, 60.0f);
        t3.setValue(this.yaw);
        t3.func_175207_a(this);
        t3.useGuiTextBackground();
        manager.focus(0);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 13, this.field_147003_i + 186, this.field_147009_r + 32, "guiText.popup.flinger.speed");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 31, this.field_147003_i + 186, this.field_147009_r + 50, "guiText.popup.flinger.pitch");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 49, this.field_147003_i + 186, this.field_147009_r + 68, "guiText.popup.flinger.yaw");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 148, this.field_147009_r + 16, GuiModuleFlinger.LARGE_TEXTFIELD_XY.x, GuiModuleFlinger.LARGE_TEXTFIELD_XY.y, 35, 14);
        this.func_73729_b(this.field_147003_i + 148, this.field_147009_r + 34, GuiModuleFlinger.LARGE_TEXTFIELD_XY.x, GuiModuleFlinger.LARGE_TEXTFIELD_XY.y, 35, 14);
        this.func_73729_b(this.field_147003_i + 148, this.field_147009_r + 52, GuiModuleFlinger.LARGE_TEXTFIELD_XY.x, GuiModuleFlinger.LARGE_TEXTFIELD_XY.y, 35, 14);
    }

    @Override
    public void func_175319_a(int id, String value) {
        switch (id) {
            case 1000: {
                this.speed = this.parse(value);
                break;
            }
            case 1001: {
                this.pitch = this.parse(value);
                break;
            }
            case 1002: {
                this.yaw = this.parse(value);
                break;
            }
            default: {
                super.func_175319_a(id, value);
                return;
            }
        }
        this.sendModuleSettingsDelayed(5);
    }

    private float parse(String s) {
        if (s.isEmpty() || s.equals("-")) {
            return 0.0f;
        }
        return Float.parseFloat(s);
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound compound = super.buildMessageData();
        compound.func_74776_a("Speed", this.speed);
        compound.func_74776_a("Pitch", this.pitch);
        compound.func_74776_a("Yaw", this.yaw);
        return compound;
    }

    private static class TooltipButton
    extends TexturedButton {
        TooltipButton(int buttonId, int x, int y, String key, float min, float max) {
            super(buttonId, x, y, 16, 16);
            this.tooltip1.add(I18n.func_135052_a((String)("guiText.tooltip.flinger." + key), (Object[])new Object[]{Float.valueOf(min), Float.valueOf(max)}));
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        protected int getTextureX() {
            return 48 + 16 * (this.field_146127_k - 1000);
        }

        @Override
        protected int getTextureY() {
            return 0;
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }
    }
}

