/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class GuiModuleDistributor
extends GuiModule {
    private static final int STRATEGY_BUTTON_ID = 1000;
    private static final int TOOLTIP_BUTTON_ID = 1001;
    private CompiledDistributorModule.DistributionStrategy strategy;

    public GuiModuleDistributor(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModuleDistributor(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledDistributorModule cdm = new CompiledDistributorModule(null, this.moduleItemStack);
        this.strategy = cdm.getDistributionStrategy();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new TooltipButton(1001, this.field_147003_i + 130, this.field_147009_r + 23));
        this.field_146292_n.add(new StrategyButton(1000, this.field_147003_i + 147, this.field_147009_r + 23, 16, 16, this.strategy));
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 21, this.field_147003_i + 165, this.field_147009_r + 41, "guiText.popup.distributor.strategy");
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1000: {
                StrategyButton sb = (StrategyButton)button;
                this.strategy = (CompiledDistributorModule.DistributionStrategy)((Object)sb.cycle(!GuiScreen.func_146272_n()));
                this.sendModuleSettingsToServer();
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound tag = super.buildMessageData();
        tag.func_74768_a("DistStrategy", this.strategy.ordinal());
        return tag;
    }

    private class TooltipButton
    extends TexturedButton {
        TooltipButton(int id, int x, int y) {
            super(id, x, y, 16, 16);
            this.tooltip1.add(I18n.func_135052_a((String)"guiText.tooltip.distributor.strategy", (Object[])new Object[0]));
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }

        @Override
        protected int getTextureX() {
            return 176;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class StrategyButton
    extends TexturedCyclerButton<CompiledDistributorModule.DistributionStrategy> {
        private final List<List<String>> tooltips;

        StrategyButton(int buttonId, int x, int y, int width, int height, CompiledDistributorModule.DistributionStrategy initialVal) {
            super(buttonId, x, y, width, height, initialVal);
            this.tooltips = Lists.newArrayList();
            for (CompiledDistributorModule.DistributionStrategy strategy : CompiledDistributorModule.DistributionStrategy.values()) {
                this.tooltips.add(Collections.singletonList(I18n.func_135052_a((String)("itemText.distributor.strategy." + (Object)((Object)strategy)), (Object[])new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((CompiledDistributorModule.DistributionStrategy)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 32;
        }

        @Override
        public List<String> getTooltip() {
            return this.tooltips.get(((CompiledDistributorModule.DistributionStrategy)((Object)this.getState())).ordinal());
        }
    }
}

