/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.fx;

import java.awt.Color;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.fx.Vector3;
import net.minecraft.world.World;

public class ParticleBeam {
    private static final int MAX_ITERS = 500;

    public static void doParticleBeam(World world, Vector3 orig, Vector3 end) {
        ParticleBeam.doParticleBeam(world, orig, end, null, 0.5f);
    }

    public static void doParticleBeam(World world, Vector3 orig, Vector3 end, Color flatColor, float size) {
        if (!world.field_72995_K) {
            return;
        }
        Vector3 diff = end.subtract(orig);
        Vector3 movement = diff.normalize().multiply(0.05);
        int iters = Math.min(500, (int)(diff.mag() / movement.mag()));
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        Vector3 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            Color color;
            if (flatColor != null) {
                color = flatColor;
            } else {
                float hue = (float)i * huePer + hueSum;
                color = Color.getHSBColor(hue, 1.0f, 1.0f);
            }
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            ModularRouters.proxy.setSparkleFXNoClip(true);
            ModularRouters.proxy.sparkleFX(world, currentPos.x, currentPos.y, currentPos.z, r, g, b, 0.5f, 4);
            ModularRouters.proxy.setSparkleFXNoClip(false);
            currentPos = currentPos.add(movement);
        }
    }
}

